<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;
use App\Models\ParCMonetaria;
use Illuminate\Support\Carbon;

class ActualizarIndicadores extends Command
{
    protected $signature = 'indicadores:actualizar';
    protected $description = 'Obtiene los valores UF, UTM, USD, EURO, IPC desde mindicador.cl y los guarda';

    public function handle()
    {
        $url = 'https://mindicador.cl/api';
        $response = Http::get($url);

        if ($response->failed()) {
            $this->error('No se pudo obtener los datos de mindicador.cl');
            return 1;
        }

        $data = $response->json();
        $fecha = Carbon::parse($data['fecha'])->toDateString();

        $indicadores = [
            'UF' => 2,
            'UTM' => 3,
            'USD' => 5,
            'EURO' => 6,
            'IPC' => 1,
        ];

        foreach ($indicadores as $nombre => $indice_id) {
            $serie = $data[strtolower($nombre)]['serie'][0] ?? null;
            if ($serie) {
                ParCMonetaria::updateOrCreate(
                    [
                        'par_ind_economico_id' => $indice_id,
                        'fecha' => Carbon::parse($serie['fecha'])->toDateString(),
                    ],
                    [
                        'valor' => $serie['valor'],
                        'fuente' => 'mindicador.cl',
                    ]
                );
            }
        }

        $this->info('✅ Indicadores económicos actualizados correctamente.');
        return 0;
    }
}
