<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Symfony\Component\Process\Process;

class DescargarLibroCommand extends Command
{
    protected $signature = 'sii:descargar-libro {rut} {clave} {mes} {anio}';
    protected $description = 'Ejecuta el script Node.js para descargar el libro desde SII';

    public function handle()
    {
        $rut = $this->argument('rut');
        $clave = $this->argument('clave');
        $mes = $this->argument('mes');
        $anio = $this->argument('anio');

        $scriptPath = base_path('scripts/descargar_sii.js');
        $nodePath = '/usr/local/bin/node'; // ⚠️ Ruta absoluta al binario de Node

        $this->info("📥 Ejecutando script con RUT: $rut | Mes: $mes $anio");
        $this->info("📂 Usando script: $scriptPath");

        $process = new Process([$nodePath, $scriptPath, $rut, $clave, $mes, $anio]);
        $process->setTimeout(300); // 5 minutos

        $process->run(function ($type, $buffer) {
            if ($type === Process::OUT) {
                $this->info("🟢 $buffer");
            } else {
                $this->error("🔴 $buffer");
            }
        });

        if (!$process->isSuccessful()) {
            $this->error('❌ Error al ejecutar el script.');
            $this->error($process->getErrorOutput());
            return Command::FAILURE;
        }

        $this->info('✅ Script ejecutado exitosamente.');
        return Command::SUCCESS;
    }
}
