<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;
use App\Models\ParCMonetaria;
use Illuminate\Support\Carbon;

class ImportarIndicadoresAnuales extends Command
{
    protected $signature = 'indicadores:importar {año}';
    protected $description = 'Importa valores anuales de UF, UTM, Dólar, Euro e IPC desde mindicador.cl';

    public function handle()
    {
        $año = $this->argument('año');

        $indicadores = [
            'uf' => 2,
            'utm' => 3,
            'dolar' => 5,
            'euro' => 6,
            'ipc' => 1,
        ];

        foreach ($indicadores as $key => $indiceId) {
            $this->importarPorAño($key, $año, $indiceId);
        }

        $this->info("✅ Importación completa para el año $año.");
    }

    public function importarPorAño($tipo, $año, $indiceId)
    {
        $this->info("📥 Importando $tipo para el año $año...");

        $url = "https://mindicador.cl/api/{$tipo}/{$año}";
        $response = Http::get($url);

        if ($response->failed()) {
            $this->error("❌ No se pudo obtener $tipo del año $año");
            return;
        }

        $serie = $response->json()['serie'] ?? [];

        foreach ($serie as $item) {
            ParCMonetaria::updateOrCreate(
                [
                    'par_ind_economico_id' => $indiceId,
                    'fecha' => Carbon::parse($item['fecha'])->toDateString(),
                ],
                [
                    'valor' => $item['valor'],
                    'fuente' => 'mindicador.cl',
                ]
            );
        }

        $this->info("✅ $tipo del año $año importado correctamente.");
    }
}
