<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Libraries\LibreDTE\ValidadorXml;
use Exception;

class ValidarDteCommand extends Command
{
    protected $signature = 'dte:validar {archivo : Nombre del archivo XML a validar (ej: DTE_33_F1.xml)} {--tipo= : Tipo de validación (dte/envio)}';

    protected $description = 'Valida un XML DTE o EnvioDTE contra los esquemas XSD del SII';

    public function handle()
    {
        $archivo = $this->argument('archivo');
        $tipo = $this->option('tipo') ?? 'dte';

        $rutaXml = storage_path("app/dtes/" . $archivo);

        $validador = new ValidadorXml();

        try {
            if ($tipo === 'envio') {
                $validador->validarEnvioDTE($rutaXml);
            } else {
                $rutaXsd = base_path('resources/schemas/DTE_v10.xsd');
                $validador->validar($rutaXml, $rutaXsd);
            }

            $this->info("✅ El archivo '$archivo' es válido según el XSD del SII.");
        } catch (Exception $e) {
            $this->error("❌ Error de validación:");
            $this->line($e->getMessage());
        }
    }
}
