<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Illuminate\Support\Arr;

class Handler extends ExceptionHandler
{
    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    /**
     * Render an exception into an HTTP response and ensure CORS headers are present.
     */
    public function render($request, Throwable $e)
    {
        $response = parent::render($request, $e);

        // Attach CORS headers consistent with config/cors.php so browsers receive them even on errors
        $cors = config('cors', []);
        $allowedOrigins = $cors['allowed_origins'] ?? ['*'];
        $origin = $request->header('Origin');
        if (in_array('*', (array) $allowedOrigins) || ($origin && in_array($origin, (array) $allowedOrigins))) {
            $response->headers->set('Access-Control-Allow-Origin', in_array('*', (array) $allowedOrigins) ? '*' : $origin);
            $response->headers->set('Vary', 'Origin');
        }

        $response->headers->set('Access-Control-Allow-Methods', implode(', ', Arr::wrap($cors['allowed_methods'] ?? ['GET','POST','PUT','DELETE','OPTIONS'])));
        $response->headers->set('Access-Control-Allow-Headers', implode(', ', Arr::wrap($cors['allowed_headers'] ?? ['*'])));
        if (!empty($cors['supports_credentials'])) {
            $response->headers->set('Access-Control-Allow-Credentials', 'true');
        }

        return $response;
    }
}
