<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contabilidad\ConCategoriaCuenta;
use App\Models\TipoCuenta;

class ConCategoriaCuentasController extends Controller
{
    public function index()
    {
        return ConCategoriaCuenta::with('tipoCuenta')->get();
    }

    public function Filtro(Request $request)
    {
        return ConCategoriaCuenta::with(['tipoCuenta',])->orderBy('nombre')->where('tipo_cuenta_id','=', $request->filtro)->where('estado',1)->get();
    }

    public function store(Request $request)
    {
        $request->validate([
            'tipo_cuenta_id' => 'required|exists:con_tipo_cuentas,id',
            'codigo' => 'required|string|max:100',
            'nombre' => 'required|string|max:100',
            'estado' => 'nullable|integer'
        ]);

        $categoria = ConCategoriaCuenta::create([
            'tipo_cuenta_id' => $request->tipo_cuenta_id,
            'codigo' => $request->codigo,
            'nombre' => $request->nombre,
            'estado' => $request->estado ?? 1
        ]);

        return response()->json($categoria, 201);
    }

    public function update(Request $request, $id)
    {
        $categoria = ConCategoriaCuenta::findOrFail($id);

        $request->validate([
            'tipo_cuenta_id' => 'required|exists:con_tipo_cuentas,id',
            'codigo' => 'required|string|max:100',
            'nombre' => 'required|string|max:100',
            'estado' => 'nullable|integer'
        ]);

        $categoria->update([
            'tipo_cuenta_id' => $request->tipo_cuenta_id,
            'codigo' => $request->codigo,
            'nombre' => $request->nombre,
            'estado' => $request->estado ?? 1
        ]);

        return response()->json($categoria);
    }

    public function show(ConCategoriaCuenta $conCategoriaCuenta)
    {
        return $conCategoriaCuenta;
    }

    public function destroy($id)
    {
        $categoria = ConCategoriaCuenta::findOrFail($id);
        $categoria->delete();

        return response()->json(['mensaje' => 'Eliminado correctamente']);
    }
}

