<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use App\Models\Contabilidad\ConClienteCuenta;
use Illuminate\Http\Request;

class ConClienteCuentaController extends Controller
{
    public function index()
    {
        return ConClienteCuenta::with(['VenCliente', 'empresa', 'conSubCuenta'])->get();
    }

    public function show($id)
    {
        $cuenta = ConClienteCuenta::with(['VenCliente', 'empresa', 'conSubCuenta'])->find($id);
        if (!$cuenta) {
            return response()->json(['error' => 'Cuenta no encontrada'], 404);
        }
        return $cuenta;
    }

    public function store(Request $request)
    {
        $request->validate([
            've_cliente_id' => 'required|exists:ven_clientes,id',
            'con_sub_cuenta_id' => 'required|exists:con_sub_cuentas,id',
            'empresa_id' => 'required|exists:par_empresas,id',
        ]);

        $cuenta = ConClienteCuenta::create([
            'ven_clientes_id' => $request->ven_clientes_id,
            'con_sub_cuenta_id' => $request->con_sub_cuenta_id,
            'par_empresa_id' => $request->empresa_id,
            'estado' => $request->estado ?? 1,
        ]);

        return response()->json($cuenta, 201);
    }

    public function update(Request $request, $id)
    {
        if ($request->tipo_update == 2) {
            $cuenta = ConClienteCuenta::where('ven_cliente_id', $request->ven_cliente_id)
                ->where('par_empresa_id', $request->empresa_id)
                ->first();

            if ($cuenta) {
                $cuenta->update([
                    'con_sub_cuenta_id' => $request->con_sub_cuenta_id,
                    'estado' => $request->estado ?? 1,
                ]);
            } else {
                $cuenta = ConClienteCuenta::create([
                    'ven_cliente_id' => $request->ven_cliente_id,
                    'par_empresa_id' => $request->empresa_id,
                    'con_sub_cuenta_id' => $request->con_sub_cuenta_id,
                    'estado' => $request->estado ?? 1,
                ]);
            }

            return response()->json($cuenta);
        }

        $cuenta = ConClienteCuenta::find($id);
        if (!$cuenta) {
            return response()->json(['error' => 'Cuenta no encontrada'], 404);
        }

        $cuenta->update($request->only([
            'ven_cliente_id',
            'con_sub_cuenta_id',
            'empresa_id',
            'estado',
        ]));

        return response()->json($cuenta);
    }

    public function destroy($id)
    {
        $cuenta = ConClienteCuenta::find($id);
        if (!$cuenta) {
            return response()->json(['error' => 'Cuenta no encontrada'], 404);
        }

        $cuenta->delete();
        return response()->json(['message' => 'Cuenta eliminada correctamente']);
    }
}
