<?php

namespace App\Http\Controllers\Contabilidad;

use Illuminate\Http\Request;
use App\Models\Contabilidad\ConCuentaMadre;
use App\Models\Contabilidad\ConCategoriaCuenta;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ConCuentaMadreController extends Controller
{
    public function index()
    {
        return ConCuentaMadre::with(['conCategoriaCuenta', 'ConCategoriaCuenta.tipoCuenta'])->where('estado', 1)->get();
    }

    public function Filtro(Request $request)
    {
        return ConCuentaMadre::with(['conCategoriaCuenta', 'ConCategoriaCuenta.tipoCuenta'])
            ->orderBy('nombre')
            ->where('con_categoria_cuenta_id', '=', $request->filtro)
            ->where('estado', 1)
            ->get();
    }

    public function store(Request $request)
    {
        return DB::transaction(function () use ($request) {
            $catCuenta = ConCategoriaCuenta::findOrFail($request->con_categoria_cuenta_id);
            $prefijo = $catCuenta->codigo;

            $ultimoCodigo = ConCuentaMadre::where('codigo', 'like', $prefijo . '%')
                ->orderByRaw('CAST(RIGHT(codigo, 2) AS UNSIGNED) DESC')
                ->lockForUpdate()
                ->value('codigo');

            $ultimoCorrelativo = $ultimoCodigo ? intval(substr($ultimoCodigo, -2)) : 0;
            $nuevoCorrelativo = str_pad($ultimoCorrelativo + 1, 2, '0', STR_PAD_LEFT);
            $codigoCuenta = $prefijo . $nuevoCorrelativo;

            $ConCuenta = new ConCuentaMadre();
            $ConCuenta->codigo = $codigoCuenta;
            $ConCuenta->nombre = $request->nombre;
            $ConCuenta->con_categoria_cuenta_id = $request->con_categoria_cuenta_id;
            $ConCuenta->estado = 1;
            $ConCuenta->save();

            return response()->json($ConCuenta, 201);
        });
    }

    public function update(Request $request, ConCuentaMadre $conCuentaMadre)
    {
        $conCuentaMadre->nombre = $request->nombre;
        $conCuentaMadre->con_categoria_cuenta_id = $request->con_categoria_cuenta_id;
        $conCuentaMadre->save();
        return $conCuentaMadre;
    }
}
