<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use App\Models\Contabilidad\ConCuenta;
use App\Models\Contabilidad\ConSubCuenta;
use Illuminate\Http\Request;
use App\Models\Contabilidad\ConCuentaMadre;
use App\Models\Contabilidad\ConCategoriaCuenta;
use Illuminate\Support\Facades\DB;

class ConCuentasController extends Controller
{
    public function index()
    {
        return ConCuenta::with(['ConPAuxiliar','ConCuentaMadre.ConCategoriaCuenta.tipoCuenta'])->where('estado',1)->get();
    }

    public function Filtro(Request $request)
    {
        return ConCuenta::with(['ConCuentaMadre.conCategoriaCuenta', 'ConCuentaMadre.ConCategoriaCuenta.tipoCuenta'])
            ->orderBy('nombre')
            ->where('con_cuenta_madre_id', '=', $request->filtro)
            ->where('estado', 1)
            ->get();
    }

    public function store(Request $request)
    {
        return DB::transaction(function () use ($request) {
            $catCuenta = ConCuentaMadre::findOrFail($request->con_cuenta_madre_id);
            $prefijo = $catCuenta->codigo;

            $ultimoCodigo = ConCuenta::where('codigo', 'like', $prefijo . '%')
                ->orderByRaw('CAST(SUBSTRING(codigo, ' . (strlen($prefijo) + 1) . ') AS UNSIGNED) DESC')
                ->lockForUpdate()
                ->value('codigo');

            $ultimoCorrelativo = $ultimoCodigo ? intval(substr($ultimoCodigo, strlen($prefijo))) : 0;
            $nuevoCorrelativo = str_pad($ultimoCorrelativo + 1, 3, '0', STR_PAD_LEFT);
            $codigoCuenta = $prefijo . $nuevoCorrelativo;

            $ConCuenta = new ConCuenta();
            $ConCuenta->codigo = $codigoCuenta;
            $ConCuenta->nombre = $request->nombre;
            $ConCuenta->con_cuenta_madre_id = $request->con_cuenta_madre_id;
            $ConCuenta->con_p_auxiliar_id = $request->con_p_auxiliar_id;
            $ConCuenta->ing_egre = $request->ing_egre;
            $ConCuenta->save();

            $subPrefijo = $codigoCuenta;

            $ultimoSubCodigo = ConSubCuenta::where('codigo', 'like', $subPrefijo . '%')
                ->orderByRaw('CAST(SUBSTRING(codigo, ' . (strlen($subPrefijo) + 1) . ') AS UNSIGNED) DESC')
                ->lockForUpdate()
                ->value('codigo');

            $ultimoSubCorrelativo = $ultimoSubCodigo ? intval(substr($ultimoSubCodigo, strlen($subPrefijo))) : 0;
            $nuevoSubCorrelativo = str_pad($ultimoSubCorrelativo + 1, 3, '0', STR_PAD_LEFT);
            $codigoSubCuenta = $subPrefijo . $nuevoSubCorrelativo;

            $ConSubCuenta = new ConSubCuenta();
            $ConSubCuenta->con_cuenta_id = $ConCuenta->id;
            $ConSubCuenta->nombre = $ConCuenta->nombre;
            $ConSubCuenta->codigo = $codigoSubCuenta;
            $ConSubCuenta->especial = 0;
            $ConSubCuenta->save();

            return response()->json([
                'cuenta' => $ConCuenta,
                'subcuenta' => $ConSubCuenta
            ]);
        });
    }

    public function show(ConCuenta $conCuenta)
    {
        return $conCuenta;
    }

    public function update(Request $request, ConCuenta $conCuenta)
    {
        $conCuenta->nombre = $request->nombre;
        $conCuenta->con_p_auxiliar_id = $request->con_p_auxiliar_id;
        $conCuenta->ing_egre = $request->ing_egre;
        $conCuenta->con_cuenta_madre_id = $request->con_cuenta_madre_id;
        $conCuenta->save();

        DB::table('con_sub_cuentas')
            ->where('con_cuenta_id', $conCuenta->id)
            ->where('especial', 0)
            ->update(['nombre' => $conCuenta->nombre]);

        return $conCuenta;
    }

    public function destroy(ConCuenta $conCuenta)
    {
        DB::beginTransaction();
        try {
            $conCuenta->estado = 0;
            $conCuenta->save();

            $conSubCuentas = ConSubCuenta::where('con_cuenta_id', $conCuenta->id)->get();

            foreach ($conSubCuentas as $conSubCuenta) {
                $conSubCuenta->estado = 0;
                $conSubCuenta->save();
            }
            DB::commit();

            return response()->json(['message' => 'Cuenta y subcuentas desactivadas correctamente.'], 200);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'No se pudo desactivar la cuenta y subcuentas.'], 500);
        }
    }
}
