<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use App\Models\Contabilidad\ConCuentasSiiCompra;
use Illuminate\Http\Request;

class ConCuentasSiiCompraController extends Controller
{
    public function index()
    {
        $cuentas = ConCuentasSiiCompra::all();
        return response()->json($cuentas);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            'empresa_id' => 'required|integer',
            'con_sub_cuenta_id' => 'required|integer',
            'estado' => 'required|integer',
        ]);

        $cuenta = ConCuentasSiiCompra::create([
            'nombre' => $validated['nombre'],
            'empresa_id' => $validated['empresa_id'],
            'con_sub_cuenta_id' => $validated['con_sub_cuenta_id'],
            'estado' => $validated['estado'],
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json($cuenta, 201);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'nombre' => 'string|max:255',
            'empresa_id' => 'integer',
            'con_sub_cuenta_id' => 'integer',
            'estado' => 'integer',
        ]);

        $cuenta = ConCuentasSiiCompra::findOrFail($id);

        $cuenta->update($validated);

        return response()->json($cuenta);
    }

    public function destroy(ConCuentasSiiCompra $conCuentasSiiCompra)
    {
        $conCuentasSiiCompra->estado = 0;
        $conCuentasSiiCompra->save();
    }
}
