<?php

namespace App\Http\Controllers\Contabilidad;

use App\Models\Contabilidad\ConFolioVoucher;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ConFolioVoucherController extends Controller
{
    public function index()
    {
        return ConFolioVoucher::all();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'fecha' => 'required|date',
            'folio' => 'required|string|max:100',
            'par_anio_id' => 'required|integer',
            'empresa_id' => 'required|integer',
            'estado' => 'nullable|integer',
        ]);

        $folio = ConFolioVoucher::create($data);

        return response()->json($folio, 201);
    }

    public function show($id)
    {
        return ConFolioVoucher::findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $folio = ConFolioVoucher::findOrFail($id);

        $folio->update($request->all());

        return response()->json($folio);
    }

    public function destroy($id)
    {
        $folio = ConFolioVoucher::findOrFail($id);
        $folio->delete();

        return response()->json(null, 204);
    }
}
