<?php

namespace App\Http\Controllers\Contabilidad;

use App\Models\Contabilidad\ConFormularioDetalle;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ConFormularioDetalleController extends Controller
{
    public function index()
    {
        return ConFormularioDetalle::with('parFormulario','parFormulario.formulario')->where('estado',1)->get();
    }

    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;
        $periodo = $request->periodo;
    $resumen = ConFormularioDetalle::where('empresa_id', $filtro)->where('par_periodo_id', $periodo)->orderBy('par_periodo_id')->where('estado',1)
        ->with('parFormulario','parFormulario.formulario')
        ->get();

        return $resumen;
    }

    public function store(Request $request)
    {
        $conParFormulario = new ConFormularioDetalle();
        $conParFormulario->con_par_formulario_id = $request->con_par_formulario_id;
        $conParFormulario->monto = $request->monto;
        $conParFormulario->empresa_id = $request->empresa_id;
        $conParFormulario->par_periodo_id = $request->par_periodo_id ?? $request->t_periodo_id;
        $conParFormulario->save();
    }

    public function show(ConFormularioDetalle $conFormularioDetalle) { }

    public function update(Request $request, ConFormularioDetalle $conFormularioDetalle)
    {
        $conFormularioDetalle->con_par_formulario_id = $request->con_par_formulario_id;
        $conFormularioDetalle->monto = $request->monto;
        $conFormularioDetalle->save();
    }

    public function destroy(ConFormularioDetalle $conFormularioDetalle) { }
}
