<?php

namespace App\Http\Controllers\Contabilidad;

use App\Models\Contabilidad\ConImpuestoTasa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ConImpuestoTasaController extends Controller
{
    public function index()
    {
        // ...existing code preserved...
    }

    public function tasa(Request $request)
    {
        $fecha = $request->input('fecha');
        if (empty($fecha)) {
            return response()->json(['error' => 'fecha es requerida (YYYY-MM-DD)'], 422);
        }

        $query = DB::table('con_impuesto_tasas')->where('activo', 1)
                ->whereDate('vigente_desde', '<=', $fecha)
                ->where(function ($q) use ($fecha) {
                    $q->whereNull('vigente_hasta')->orWhereDate('vigente_hasta', '>=', $fecha);
                });

        if ($request->filled('con_impuesto_id')) {
            $query->where('con_impuesto_id', (int) $request->input('con_impuesto_id'));
        }

        $rows = $query->select(['id','con_impuesto_id','tasa','monto_fijo','vigente_desde','vigente_hasta','activo','created_at','updated_at'])->get();

        return response()->json(['ok' => true, 'data' => $rows]);
    }

    public function store(Request $request)
    {
        // ...existing code preserved...
    }

    public function show(ConImpuestoTasa $conImpuestoTasa)
    {
        // ...existing code preserved...
    }

    public function update(Request $request, ConImpuestoTasa $conImpuestoTasa)
    {
        // ...existing code preserved...
    }

    public function destroy(ConImpuestoTasa $conImpuestoTasa)
    {
        // ...existing code preserved...
    }
}
