<?php

namespace App\Http\Controllers\Contabilidad;

use App\Models\Contabilidad\ConLibroDiario;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ConLibroDiarioController extends Controller
{
    // Mostrar todos los registros
    public function index()
    {
        $libros = ConLibroDiario::all();
        return response()->json($libros);
    }

    public function Filtro(Request $request)

    
    {
        $filtro = $request->filtro;
        $periodo = $request->periodo;
    return ConLibroDiario::where('empresa_id', $filtro)->where('par_periodo_id', $periodo)->orderBy('par_periodo_id')->where('estado',1)->get();
    }
    // Mostrar un registro especifico
    public function show($id)
    {
        $libro = ConLibroDiario::findOrFail($id);
        return response()->json($libro); 
    }

    // Crear un nuevo registro
    public function store(Request $request)
    {
        $request->validate([
            'voucher_id' => 'required|exists:con_vouchers,id',
            'sub_cuenta_id' => 'required|exists:con_sub_cuentas,id',
            'monto' => 'required|numeric',
            'estado' => 'nullable|integer',
        ]);

        $libro = ConLibroDiario::create([
            'voucher_id' => $request->voucher_id,
            'sub_cuenta_id' => $request->sub_cuenta_id,
            'monto' => $request->monto,
            'estado' => $request->estado ?? 1,
        ]);

        return response()->json($libro, 201);
    }

    // Actualizar un registro existente
    public function update(Request $request, $id)
    {
        $request->validate([
            'voucher_id' => 'required|exists:con_vouchers,id',
            'sub_cuenta_id' => 'required|exists:con_sub_cuentas,id',
            'monto' => 'required|numeric',
            'estado' => 'nullable|integer',
        ]);

        $libro = ConLibroDiario::findOrFail($id);
        $libro->update([
            'voucher_id' => $request->voucher_id,
            'sub_cuenta_id' => $request->sub_cuenta_id,
            'monto' => $request->monto,
            'estado' => $request->estado ?? 1,
        ]);

        return response()->json($libro);
    }

    // Eliminar un registro
    public function destroy($id)
    {
        $libro = ConLibroDiario::findOrFail($id);
        $libro->delete();

        return response()->json(['message' => 'Registro eliminado correctamente']);
    }
}
