<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contabilidad\ConPAuxiliar;

class ConPAuxiliaresController extends Controller
{
    public function index()
    {
        return ConPAuxiliar::all();
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:100',
            'estado' => 'nullable|integer'
        ]);

        $auxiliar = ConPAuxiliar::create([
            'nombre' => $request->nombre,
            'estado' => $request->estado ?? 1
        ]);

        return response()->json($auxiliar, 201);
    }

    public function update(Request $request, $id)
    {
        $auxiliar = ConPAuxiliar::findOrFail($id);

        $request->validate([
            'nombre' => 'required|string|max:100',
            'estado' => 'nullable|integer'
        ]);

        $auxiliar->update([
            'nombre' => $request->nombre,
            'estado' => $request->estado ?? 1
        ]);

        return response()->json($auxiliar);
    }

    public function destroy($id)
    {
        $auxiliar = ConPAuxiliar::findOrFail($id);
        $auxiliar->delete();

        return response()->json(['mensaje' => 'Eliminado correctamente']);
    }
}

