<?php

namespace App\Http\Controllers\Contabilidad;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Models\Contabilidad\ConParFormulario;
use App\Http\Controllers\Controller;

class ConParFormularioController extends Controller
{
    public function index()
    {
        return ConParFormulario::with('formulario')->where('estado',1)->get();
    }

   public function store(Request $request)
{
    $request->validate([
        'con_formulario_id' => 'required|integer',
        'codigo' => [
            'required',
            'string',
            Rule::unique('con_par_formularios')->where(function ($query) use ($request) {
                return $query->where('con_formulario_id', $request->con_formulario_id)
                             ->where('codigo', $request->codigo);
            }),
        ],
        'd_corta' => 'nullable|string',
        'd_formulario' => 'nullable|string',
    ]);

    $conParFormulario = new ConParFormulario();
    $conParFormulario->con_formulario_id = $request->con_formulario_id;
    $conParFormulario->codigo = $request->codigo;
    $conParFormulario->d_corta = $request->d_corta;
    $conParFormulario->d_formulario = $request->d_formulario;
    $conParFormulario->save();

    return response()->json(['success' => true, 'message' => 'Formulario creado con éxito']);
}

public function update(Request $request, ConParFormulario $conParFormulario)
{
    $request->validate([
        'con_formulario_id' => 'required|integer',
        'codigo' => [
            'required',
            'string',
            Rule::unique('con_par_formularios')
                ->where(function ($query) use ($request) {
                    return $query->where('con_formulario_id', $request->con_formulario_id);
                })
                ->ignore($conParFormulario->id),
        ],
        'd_corta' => 'nullable|string',
        'd_formulario' => 'nullable|string',
    ]);

    $conParFormulario->con_formulario_id = $request->con_formulario_id;
    $conParFormulario->codigo = $request->codigo;
    $conParFormulario->d_corta = $request->d_corta;
    $conParFormulario->d_formulario = $request->d_formulario;
    $conParFormulario->save();

    return response()->json(['success' => true, 'message' => 'Formulario actualizado con éxito']);
}

    public function show(ConParFormulario $conParFormulario)
    {
        //
    }

    public function destroy(ConParFormulario $conParFormulario)
    {
        //
    }
}
