<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use App\Models\Contabilidad\ConSiiCompra;
use App\Models\Contabilidad\ConSubCuenta;
use Illuminate\Http\Request;
use App\Models\Contabilidad\ConPreLibCompra;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ConPreLibCompraController extends Controller
{
    public function index()
    {
        $resumen = ConPreLibCompra::select(
                'par_empresa_id',
                'con_sub_cuenta_id',
                'par_periodo_id',
                'con_voucher_id',
                'con_voucher_p_id',
                'par_anio_id',
                DB::raw('SUM(debe) as total_debe'),
                DB::raw('SUM(haber) as total_haber')
            )
            ->where('estado', 1)
            ->groupBy('par_empresa_id', 'con_sub_cuenta_id','par_periodo_id','par_anio_id', 'con_voucher_id',
                'con_voucher_p_id',)
            ->with('ConSubCuenta')
            ->get();

        return $resumen;
    }

    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;
        $periodo = $request->periodo;
    $resumen = ConPreLibCompra::where('par_empresa_id', $filtro)->where('par_periodo_id', $periodo)->orderBy('par_periodo_id')->where('estado',1)
        ->with('ConSubCuenta','conSiiCompra')
        ->get();

        return $resumen;
    }

    public function FiltroCompra(Request $request)
    {
        $filtro = $request->filtro;
        $periodo = $request->periodo;
        $cuenta = $request->cuenta;

        $resumen = ConPreLibCompra::select(
            'con_pre_lib_compras.par_empresa_id',
            'con_pre_lib_compras.con_sub_cuenta_id',
            'con_pre_lib_compras.par_periodo_id',
        'con_pre_lib_compras.par_anio_id',
            'con_sii_compras.Razon_Social as razon_social',
            'con_sii_compras.proveedor_id as proveedor_id',
            DB::raw('SUM(con_pre_lib_compras.debe) as total_debe'),
            DB::raw('SUM(con_pre_lib_compras.haber) as total_haber')
        )
        ->leftJoin('con_sii_compras', 'con_sii_compras.id', '=', 'con_pre_lib_compras.con_sii_libro_id')
        ->where('con_pre_lib_compras.par_empresa_id', $filtro)
        ->where('con_pre_lib_compras.par_periodo_id', $periodo)
        ->where('con_pre_lib_compras.con_sub_cuenta_id', $cuenta)
        ->where('con_pre_lib_compras.estado', 1)
        ->groupBy(
            'con_pre_lib_compras.par_empresa_id',
            'con_pre_lib_compras.con_sub_cuenta_id',
            'con_pre_lib_compras.par_periodo_id',
        'con_pre_lib_compras.par_anio_id',
            'con_sii_compras.Razon_Social',
            'con_sii_compras.proveedor_id'
        )
        ->orderBy('con_sii_compras.Razon_Social')
        ->with('ConSubCuenta')
        ->get();

        return $resumen;
    }

    public function FiltroFactura(Request $request)
    {
        $filtro = $request->filtro;
        $periodo = $request->periodo;
        $cuenta = $request->cuenta;
        $proveedor = $request->proveedor;

        $resumen = ConPreLibCompra::select(
            'con_pre_lib_compras.id',
            'con_pre_lib_compras.par_empresa_id',
            'con_pre_lib_compras.con_sub_cuenta_id',
            'con_pre_lib_compras.par_periodo_id',
        'con_pre_lib_compras.par_anio_id',
            'con_pre_lib_compras.con_sii_libro_id',
            'con_sii_compras.Razon_Social as razon_social',
            'con_sii_compras.proveedor_id as proveedor_id',
            'con_sii_compras.Nro',
            'con_doc_tributarios.nombre',
            'con_pre_lib_compras.debe',
            'con_pre_lib_compras.haber',
        )
        ->leftJoin('con_sii_compras', 'con_sii_compras.id', '=', 'con_pre_lib_compras.con_sii_libro_id')
        ->leftJoin('con_doc_tributarios', 'con_doc_tributarios.codigo', '=', 'con_sii_compras.Tipo_Doc')
        ->where('con_pre_lib_compras.par_empresa_id', $filtro)
        ->where('con_pre_lib_compras.par_periodo_id', $periodo)
        ->where('con_pre_lib_compras.con_sub_cuenta_id', $cuenta)
        ->where('con_sii_compras.proveedor_id', $proveedor)
        ->where('con_pre_lib_compras.estado', 1)
        ->groupBy(
            'con_pre_lib_compras.id',
            'con_doc_tributarios.nombre',
            'con_sii_compras.Nro',
            'con_pre_lib_compras.par_empresa_id',
            'con_pre_lib_compras.con_sub_cuenta_id',
             'con_pre_lib_compras.con_sii_libro_id',
        'con_pre_lib_compras.par_periodo_id',
        'con_pre_lib_compras.par_anio_id',
            'con_sii_compras.Razon_Social',
            'con_sii_compras.proveedor_id',
            'con_pre_lib_compras.debe',
            'con_pre_lib_compras.haber',
        )
        ->orderBy('con_sii_compras.Razon_Social')
        ->with('ConSubCuenta')
        ->get();

        return $resumen;
    }


    public function store(Request $request)
    {
        Log::info('📥 Request recibido en conPreLibCompras:', $request->all());

        $items = $request->input('libro');

        if (!$items || !is_array($items)) {
            return response()->json(['mensaje' => 'No se enviaron items válidos.'], 400);
        }

        foreach ($items as $item) {
            array_walk_recursive($item, function (&$value) {
                if (is_string($value)) {
                    $value = mb_convert_encoding($value, 'UTF-8', 'UTF-8');
                }
            });

            Log::info('➡ Registrando item del libro:', $item);

            $codDoc = $item['cod_doc'] ?? null;

            $calculo = DB::table('con_doc_tributarios')
                ->where('codigo', $codDoc)
                ->value('calculo');

            $debe = $item['monto1'] ?? 0;
            $haber = $item['monto2'] ?? 0;

            if ($calculo == 2) {
                $debe = $debe != 0 ? -abs($debe) : 0;
                $haber = $haber != 0 ? -abs($haber) : 0;
            }

            if ($debe == 0 && $haber == 0) {
                continue;
            }

            ConPreLibCompra::create([
                'con_sii_libro_id'   => $item['registro_id'],
                'con_sub_cuenta_id'  => $item['con_sub_cuenta_id'] ?? 1,
                'debe'               => $debe,
                'haber'              => $haber,
                'par_c_costo_id'     => $item['par_c_costo_id'] ?? null,
                'par_empresa_id'         => $item['par_empresa_id'] ?? 1,
                'par_periodo_id'       => $item['par_periodo_id'] ?? 1,
                'par_anio_id'            => $item['par_anio_id'] ?? $item['par_anio_id'] ?? $item['ano_id'] ?? 1,
            ]);

            DB::table('con_sii_compras')
                ->where('id', $item['registro_id'])
                ->update(['estado' => 0]);
        }

       return response()->json([
        'mensaje' => mb_convert_encoding('Guardado con éxito', 'UTF-8', 'UTF-8')
    ]);
    }

    public function show(ConPreLibCompra $conPreLibCompra)
    {
        //
    }

    public function actualizarFacturas(Request $request)
    {
        $facturas = $request->input('facturas');

        if (!is_array($facturas)) {
            return response()->json(['error' => 'El campo facturas debe ser un array'], 422);
        }

        $ultimoRegistroValido = null;

        foreach ($facturas as $factura) {
            if (!empty($factura['id'])) {
                $registro = ConPreLibCompra::find($factura['id']);
                if ($registro) {
                    $registro->con_sub_cuenta_id = $factura['con_sub_cuenta_id'] ?? $registro->con_sub_cuenta_id;
                    $registro->debe = $factura['debe'] ?? $registro->debe;
                    $registro->haber = $factura['haber'] ?? $registro->haber;
                    $registro->save();

                    $ultimoRegistroValido = $registro;
                }
            } else if ($ultimoRegistroValido) {
                ConPreLibCompra::create([
                    'par_empresa_id'         => $ultimoRegistroValido->par_empresa_id,
                    'con_sii_libro_id'   => $ultimoRegistroValido->con_sii_libro_id,
                    'par_anio_id'            => $ultimoRegistroValido->par_anio_id,
                    'par_periodo_id'       => $ultimoRegistroValido->par_periodo_id,
                    'glosa'              => $ultimoRegistroValido->glosa,
                    'tipo'               => $factura['tipo'] ?? $ultimoRegistroValido->tipo,
                    'con_sub_cuenta_id'  => $factura['con_sub_cuenta_id'] ?? $ultimoRegistroValido->con_sub_cuenta_id,
                    'debe'               => $factura['debe'] ?? 0,
                    'haber'              => $factura['haber'] ?? 0,
                    'user_id'            => $ultimoRegistroValido->user_id,
                ]);
            }
        }

        return response()->json(['message' => 'Facturas actualizadas y nuevas registradas correctamente']);
    }

    public function actualizarMasivoPorProveedor(Request $request)
    {
        Log::info('📥 Request recibido en conPreLibCompras:', $request->all());

        $request->validate([
            'con_sub_cuenta_id' => 'required|integer',
            'ids' => 'required|array',
            'ids.*' => 'integer',
        ]);

        try {
            ConPreLibCompra::whereIn('id', $request->ids)
                ->update(['con_sub_cuenta_id' => $request->con_sub_cuenta_id]);

            return response()->json(['message' => 'Registros actualizados correctamente']);
        } catch (\Exception $e) {
            Log::error('❌ Error al actualizar masivo: ' . $e->getMessage());
            return response()->json(['error' => 'Error al actualizar registros'], 500);
        }
    }

    public function destroy(ConPreLibCompra $conPreLibCompra)
    {
        //
    }
}
