<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Contabilidad\ConPreLibHCompra;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ConPreLibHCompraController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $resumen = ConPreLibHCompra::select(
                'par_empresa_id',
                'con_sub_cuenta_id',
                'par_periodo_id',
                'con_voucher_id',
                'con_voucher_p_id',
                'par_anio_id',
                DB::raw('SUM(debe) as total_debe'),
                DB::raw('SUM(haber) as total_haber')
            )
            ->where('estado', 1)
            ->groupBy('par_empresa_id', 'con_sub_cuenta_id','par_periodo_id','par_anio_id','con_voucher_id',
                'con_voucher_p_id',)
            ->with('ConSubCuenta')
            ->get();
    
        return $resumen;
    }
    

    public function Filtro(Request $request)

    
    {
        $filtro = $request->filtro;
        $periodo = $request->periodo;
        $resumen = ConPreLibHCompra::where('par_empresa_id', $filtro)->where('par_periodo_id', $periodo)->orderBy('par_periodo_id')->where('estado',1)
        ->with('ConSubCuenta','conSiiHCompra')
        ->get();

        return $resumen;
    }
   public function FiltroCompra(Request $request)
{
    $filtro = $request->filtro;
    $periodo = $request->periodo;
    $cuenta = $request->cuenta;

    $resumen = ConPreLibHCompra::select(
        'con_pre_lib_h_compras.par_empresa_id',
        'con_pre_lib_h_compras.con_sub_cuenta_id',
        'con_pre_lib_h_compras.par_periodo_id',
        'con_pre_lib_h_compras.par_anio_id',
        'con_sii_h_compras.nombre_razon_social as razon_social',
        'con_sii_h_compras.proveedor_id as proveedor_id',
        DB::raw('SUM(con_pre_lib_h_compras.debe) as total_debe'),
        DB::raw('SUM(con_pre_lib_h_compras.haber) as total_haber')
    )
    ->leftJoin('con_sii_h_compras', 'con_sii_h_compras.id', '=', 'con_pre_lib_h_compras.con_sii_h_compra_id')
    ->where('con_pre_lib_h_compras.par_empresa_id', $filtro)
    ->where('con_pre_lib_h_compras.par_periodo_id', $periodo)
    ->where('con_pre_lib_h_compras.con_sub_cuenta_id', $cuenta)
    ->where('con_pre_lib_h_compras.estado', 1)
    ->groupBy(
        'con_pre_lib_h_compras.par_empresa_id',
        'con_pre_lib_h_compras.con_sub_cuenta_id',
        'con_pre_lib_h_compras.par_periodo_id',
        'con_pre_lib_h_compras.par_anio_id',
        'con_sii_h_compras.nombre_razon_social',
        'con_sii_h_compras.proveedor_id'
    )
    ->orderBy('con_sii_h_compras.nombre_razon_social')
    ->with('ConSubCuenta')
    ->get();

    return $resumen;
}

public function FiltroFactura(Request $request)
{
    $filtro = $request->filtro;
    $periodo = $request->periodo;
    $cuenta = $request->cuenta;
    $proveedor = $request->proveedor;

    $resumen = ConPreLibHCompra::select(
        'con_pre_lib_h_compras.id',
        'con_pre_lib_h_compras.par_empresa_id',
        'con_pre_lib_h_compras.con_sub_cuenta_id',
        'con_pre_lib_h_compras.par_periodo_id',
        'con_pre_lib_h_compras.par_anio_id',
        'con_pre_lib_h_compras.con_sii_h_compra_id',
        'con_sii_h_compras.nombre_razon_social as razon_social',
        'con_sii_h_compras.proveedor_id as proveedor_id',
        'con_sii_h_compras.numero',
        'con_doc_tributarios.nombre',
        'con_pre_lib_h_compras.debe',
        'con_pre_lib_h_compras.haber',
    )
    ->leftJoin('con_sii_h_compras', 'con_sii_h_compras.id', '=', 'con_pre_lib_h_compras.con_sii_h_compra_id')
    ->leftJoin('con_doc_tributarios', 'con_doc_tributarios.codigo', '=', 'con_sii_h_compras.Tipo_Doc')
    ->where('con_pre_lib_h_compras.par_empresa_id', $filtro)
    ->where('con_pre_lib_h_compras.par_periodo_id', $periodo)
    ->where('con_pre_lib_h_compras.con_sub_cuenta_id', $cuenta)
    ->where('con_sii_h_compras.proveedor_id', $proveedor)
    ->where('con_pre_lib_h_compras.estado', 1)
    ->groupBy(
        'con_pre_lib_h_compras.id',
        'con_doc_tributarios.nombre',
        'con_sii_h_compras.numero',
        'con_pre_lib_h_compras.par_empresa_id',
        'con_pre_lib_h_compras.con_sub_cuenta_id',
         'con_pre_lib_h_compras.con_sii_h_compra_id',
        'con_pre_lib_h_compras.par_periodo_id',
        'con_pre_lib_h_compras.par_anio_id',
        'con_sii_h_compras.nombre_razon_social',
        'con_sii_h_compras.proveedor_id',
        'con_pre_lib_h_compras.debe',
        'con_pre_lib_h_compras.haber',
    )
    ->orderBy('con_sii_h_compras.nombre_razon_social')
    ->with('ConSubCuenta')
    ->get();

    return $resumen;
}
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

public function actualizarFacturas(Request $request)
{
    $facturas = $request->input('facturas');

    if (!is_array($facturas)) {
        return response()->json(['error' => 'El campo facturas debe ser un array'], 422);
    }

    $ultimoRegistroValido = null;

    foreach ($facturas as $factura) {
        if (!empty($factura['id'])) {
            // 🔁 ACTUALIZAR
            $registro = ConPreLibHCompra::find($factura['id']);
            if ($registro) {
                $registro->con_sub_cuenta_id = $factura['con_sub_cuenta_id'] ?? $registro->con_sub_cuenta_id;
                $registro->debe = $factura['debe'] ?? $registro->debe;
                $registro->haber = $factura['haber'] ?? $registro->haber;
                $registro->save();

                // 💾 Guardamos como último registro base
                $ultimoRegistroValido = $registro;
            }
        } else if ($ultimoRegistroValido) {
            // ➕ CREAR NUEVO usando campos heredados del último
            ConPreLibHCompra::create([
                'par_empresa_id'         => $ultimoRegistroValido->par_empresa_id,
                'con_sii_h_compra_id'   => $ultimoRegistroValido->con_sii_h_compra_id,
                'par_anio_id'            => $ultimoRegistroValido->par_anio_id,
                'par_periodo_id'       => $ultimoRegistroValido->par_periodo_id,
                'glosa'              => $ultimoRegistroValido->glosa,
                'tipo'               => $factura['tipo'] ?? $ultimoRegistroValido->tipo,
                'con_sub_cuenta_id'  => $factura['con_sub_cuenta_id'] ?? $ultimoRegistroValido->con_sub_cuenta_id,
                'debe'               => $factura['debe'] ?? 0,
                'haber'              => $factura['haber'] ?? 0,
                'user_id'            => $ultimoRegistroValido->user_id,
            ]);
        }
    }

    return response()->json(['message' => 'Facturas actualizadas y nuevas registradas correctamente']);
}

   public function store(Request $request)
{
    Log::info('📥 Request recibido en conPreLibHCompras:', $request->all());

    $items = $request->input('libro');

    if (!$items || !is_array($items)) {
        return response()->json(['mensaje' => 'No se enviaron items válidos.'], 400);
    }

    foreach ($items as $item) {
        Log::info('➡ Registrando item del libro:', $item);

        $codDoc = $item['cod_doc'] ?? null;

        // Consultar el campo 'calculo' desde con_doc_tributarios
        $calculo = DB::table('con_doc_tributarios')
            ->where('codigo', $codDoc)
            ->value('calculo');

        // Asignar a 'debe' y 'haber' según los valores de monto1 y monto2
        $debe = $item['monto1'] ?? 0;
        $haber = $item['monto2'] ?? 0;

        // Si calculo es 2 => convertir a negativos
        if ($calculo == 2) {
            $debe = $debe != 0 ? -abs($debe) : 0;
            $haber = $haber != 0 ? -abs($haber) : 0;
        }

        // Si ambos son cero, omitimos el registro
        if ($debe == 0 && $haber == 0) {
            continue;
        }

        // Guardamos el registro
        ConPreLibHCompra::create([
            'con_sii_h_compra_id' => $item['registro_id'],
            'con_sub_cuenta_id' => $item['con_sub_cuenta_id'] ?? 1,
            'debe' => $debe,
            'haber' => $haber,
            'par_c_costo_id' => $item['par_c_costo_id'] ?? null,
            'par_empresa_id'=> $item['par_empresa_id'] ?? 1,
            'par_periodo_id'=> $item['par_periodo_id'] ?? 1,
            'par_anio_id'=> $item['par_anio_id'] ?? 1,
            'centralizado' => 0,
        ]);

        // Actualizamos el estado del registro en con_sii_h_compras
        DB::table('con_sii_h_compras')
            ->where('id', $item['registro_id'])
            ->update(['estado' => 0]);
    }

    return response()->json(['mensaje' => 'Guardado con éxito']);
}

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ConPreLibHCompra  $conPreLibHCompra
     * @return \Illuminate\Http\Response
     */
    public function show(ConPreLibHCompra $conPreLibHCompra)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ConPreLibHCompra  $conPreLibHCompra
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ConPreLibHCompra $conPreLibHCompra)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ConPreLibHCompra  $conPreLibHCompra
     * @return \Illuminate\Http\Response
     */
    public function destroy(ConPreLibHCompra $conPreLibHCompra)
    {
        //
    }
}