<?php

namespace App\Http\Controllers\Contabilidad;

use Illuminate\Http\Request;
use App\Models\Contabilidad\conPreLibHVenta;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ConPreLibHVentaController extends Controller
{
    public function index()
    {
         $resumen = conPreLibHVenta::select(
                'empresa_id',
                'con_sub_cuenta_id',
                't_periodo_id',
                'con_voucher_id',
                'con_voucher_p_id',
                'par_anio_id',
                DB::raw('SUM(debe) as total_debe'),
                DB::raw('SUM(haber) as total_haber')
            )
            ->where('estado', 1)
            ->groupBy('empresa_id', 'con_sub_cuenta_id','t_periodo_id','par_anio_id','con_voucher_id',
                'con_voucher_p_id',)
            ->with('ConSubCuenta')
            ->get();
    
        return $resumen;
    }
}
