<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\Models\Contabilidad\ConPreLibVenta;
use Illuminate\Support\Facades\DB;

class ConPreLibVentaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
   public function index()
    {
        $resumen = ConPreLibVenta::select(
                'par_empresa_id',
                'con_sub_cuenta_id',
                'par_periodo_id',
                'con_voucher_id',
                'con_voucher_p_id',
                'par_anio_id',
                DB::raw('SUM(debe) as total_debe'),
                DB::raw('SUM(haber) as total_haber')
            )
            ->where('estado', 1)
            ->groupBy('par_empresa_id', 'con_sub_cuenta_id','par_periodo_id','par_anio_id','con_voucher_id',
                'con_voucher_p_id',)
            ->with('ConSubCuenta')
            ->get();
    
        return $resumen;
    }
    

    public function Filtro(Request $request)

    
    {
        $filtro = $request->filtro;
        $periodo = $request->periodo;
        $resumen = ConPreLibVenta::where('par_empresa_id', $filtro)->where('par_periodo_id', $periodo)->orderBy('par_periodo_id')->where('estado',1)
        ->with('ConSubCuenta','conSiiVenta')
        ->get();

        return $resumen;
    }

public function FiltroVenta(Request $request)
{
    $filtro = $request->filtro;
    $periodo = $request->periodo;
    $cuenta = $request->cuenta;

    $resumen = ConPreLibVenta::select(
        'con_pre_lib_ventas.par_empresa_id',
        'con_pre_lib_ventas.con_sub_cuenta_id',
        'con_pre_lib_ventas.par_periodo_id',
        'con_pre_lib_ventas.par_anio_id',
        'con_sii_ventas.Razon_Social as razon_social',
        'con_sii_ventas.ven_cliente_id as ven_cliente_id',
        DB::raw('SUM(con_pre_lib_ventas.debe) as total_debe'),
        DB::raw('SUM(con_pre_lib_ventas.haber) as total_haber')
    )
    ->leftJoin('con_sii_ventas', 'con_sii_ventas.id', '=', 'con_pre_lib_ventas.con_sii_libro_id')
    ->where('con_pre_lib_ventas.par_empresa_id', $filtro)
    ->where('con_pre_lib_ventas.par_periodo_id', $periodo)
    ->where('con_pre_lib_ventas.con_sub_cuenta_id', $cuenta)
    ->where('con_pre_lib_ventas.estado', 1)
    ->groupBy(
        'con_pre_lib_ventas.par_empresa_id',
        'con_pre_lib_ventas.con_sub_cuenta_id',
        'con_pre_lib_ventas.par_periodo_id',
        'con_pre_lib_ventas.par_anio_id',
        'con_sii_ventas.Razon_Social',
        'con_sii_ventas.ven_cliente_id'
    )
    ->orderBy('con_sii_ventas.Razon_Social')
    ->with('ConSubCuenta')
    ->get();

    return $resumen;
}

public function FiltroFactura(Request $request)
{
    $filtro = $request->filtro;
    $periodo = $request->periodo;
    $cuenta = $request->cuenta;
    $cliente = $request->cliente;

    $resumen = ConPreLibVenta::select(
        'con_pre_lib_ventas.id',
        'con_pre_lib_ventas.par_empresa_id',
        'con_pre_lib_ventas.con_sub_cuenta_id',
        'con_pre_lib_ventas.par_periodo_id',
        'con_pre_lib_ventas.par_anio_id',
        'con_pre_lib_ventas.con_sii_libro_id',
        'con_sii_ventas.Razon_Social as razon_social',
        'con_sii_ventas.ven_cliente_id as ven_cliente_id',
        'con_sii_ventas.Nro',
        'con_doc_tributarios.nombre',
        'con_pre_lib_ventas.debe',
        'con_pre_lib_ventas.haber',
    )
    ->leftJoin('con_sii_ventas', 'con_sii_ventas.id', '=', 'con_pre_lib_ventas.con_sii_libro_id')
    ->leftJoin('con_doc_tributarios', 'con_doc_tributarios.codigo', '=', 'con_sii_ventas.Tipo_Doc')
    ->where('con_pre_lib_ventas.par_empresa_id', $filtro)
    ->where('con_pre_lib_ventas.par_periodo_id', $periodo)
    ->where('con_pre_lib_ventas.con_sub_cuenta_id', $cuenta)
    ->where('con_sii_ventas.ven_cliente_id', $cliente)
    ->where('con_pre_lib_ventas.estado', 1)
    ->groupBy(
        'con_pre_lib_ventas.id',
        'con_doc_tributarios.nombre',
        'con_sii_ventas.Nro',
        'con_pre_lib_ventas.par_empresa_id',
        'con_pre_lib_ventas.con_sub_cuenta_id',
         'con_pre_lib_ventas.con_sii_libro_id',
        'con_pre_lib_ventas.par_periodo_id',
        'con_pre_lib_ventas.par_anio_id',
        'con_sii_ventas.Razon_Social',
        'con_sii_ventas.ven_cliente_id',
        'con_pre_lib_ventas.debe',
        'con_pre_lib_ventas.haber',
    )
    ->orderBy('con_sii_ventas.Razon_Social')
    ->with('ConSubCuenta')
    ->get();

    return $resumen;
}



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('📥 Request recibido en conPreLibVentas:', $request->all());
    
        $items = $request->input('libro');
    
        if (!$items || !is_array($items)) {
            return response()->json(['mensaje' => 'No se enviaron items válidos.'], 400);
        }
    
        foreach ($items as $item) {
            Log::info('➡ Registrando item del libro:', $item);
    
            $codDoc = $item['cod_doc'] ?? null;
    
            // Consultar el campo 'calculo' desde con_doc_tributarios
            $calculo = DB::table('con_doc_tributarios')
                ->where('codigo', $codDoc)
                ->value('calculo');
    
            // Asignar a 'debe' y 'haber' según los valores de monto1 y monto2
            $debe = $item['monto1'] ?? 0;
            $haber = $item['monto2'] ?? 0;
    
            // Si calculo es 2 => convertir a negativos
            if ($calculo == 2) {
                $debe = $debe != 0 ? -abs($debe) : 0;
                $haber = $haber != 0 ? -abs($haber) : 0;
            }
    
            // Si ambos son cero, omitimos el registro
            if ($debe == 0 && $haber == 0) {
                continue;
            }
    
            // Guardamos el registro
            ConPreLibVenta::create([
                'con_sii_libro_id' => $item['registro_id'],
                'con_sub_cuenta_id' => $item['con_sub_cuenta_id'] ?? 1,
                'debe' => $debe,
                'haber' => $haber,
                'par_empresa_id'=> $item['par_empresa_id'] ?? 1,
                'par_periodo_id'=> $item['par_periodo_id'] ?? 1,
                'par_anio_id'=> $item['par_anio_id'] ?? 1,
            ]);
    
            // Actualizamos el estado del registro
            DB::table('con_sii_ventas')
                ->where('id', $item['registro_id'])
                ->update(['estado' => 0]);
        }
    
        return response()->json(['mensaje' => 'Guardado con éxito']);
    }
    
    
    

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ConPreLibVenta  $conPreLibVenta
     * @return \Illuminate\Http\Response
     */
    public function show(ConPreLibVenta $conPreLibVenta)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ConPreLibVenta  $conPreLibCompra
     * @return \Illuminate\Http\Response
     */
public function actualizarFacturas(Request $request)
{
    $facturas = $request->input('facturas');

    if (!is_array($facturas)) {
        return response()->json(['error' => 'El campo facturas debe ser un array'], 422);
    }

    $ultimoRegistroValido = null;

    foreach ($facturas as $factura) {
        if (!empty($factura['id'])) {
            // 🔁 ACTUALIZAR
            $registro = ConPreLibVenta::find($factura['id']);
            if ($registro) {
                $registro->con_sub_cuenta_id = $factura['con_sub_cuenta_id'] ?? $registro->con_sub_cuenta_id;
                $registro->debe = $factura['debe'] ?? $registro->debe;
                $registro->haber = $factura['haber'] ?? $registro->haber;
                $registro->save();

                // 💾 Guardamos como último registro base
                $ultimoRegistroValido = $registro;
            }
        } else if ($ultimoRegistroValido) {
            // ➕ CREAR NUEVO usando campos heredados del último
            ConPreLibVenta::create([
                'par_empresa_id'         => $ultimoRegistroValido->par_empresa_id,
                'con_sii_libro_id'   => $ultimoRegistroValido->con_sii_libro_id,
                'par_anio_id'            => $ultimoRegistroValido->par_anio_id,
                'par_periodo_id'       => $ultimoRegistroValido->par_periodo_id,
                'glosa'              => $ultimoRegistroValido->glosa,
                'tipo'               => $factura['tipo'] ?? $ultimoRegistroValido->tipo,
                'con_sub_cuenta_id'  => $factura['con_sub_cuenta_id'] ?? $ultimoRegistroValido->con_sub_cuenta_id,
                'debe'               => $factura['debe'] ?? 0,
                'haber'              => $factura['haber'] ?? 0,
                'user_id'            => $ultimoRegistroValido->user_id,
            ]);
        }
    }

    return response()->json(['message' => 'Facturas actualizadas y nuevas registradas correctamente']);
}


    public function actualizarMasivoPorCliente(Request $request)
{
    Log::info('📥 Request recibido en conPreLibClientes:', $request->all());

    $request->validate([
        'con_sub_cuenta_id' => 'required|integer',
        'ids' => 'required|array',
        'ids.*' => 'integer',
    ]);

    try {
        // Actualizar en bloque
        ConPreLibVenta::whereIn('id', $request->ids)
            ->update(['con_sub_cuenta_id' => $request->con_sub_cuenta_id]);

        return response()->json(['message' => 'Registros actualizados correctamente']);
    } catch (\Exception $e) {
        Log::error('❌ Error al actualizar masivo: ' . $e->getMessage());
        return response()->json(['error' => 'Error al actualizar registros'], 500);
    }
}

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ConPreLibVenta  $conPreLibVenta
     * @return \Illuminate\Http\Response
     */
    public function destroy(ConPreLibVenta $conPreLibVenta)
    {
        //
    }
}