<?php

namespace App\Http\Controllers\Contabilidad;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Contabilidad\ConProveedorCuenta;
use App\Models\Proveedor;
use App\Models\Parametros\ParEmpresa as ParEmpresa;
use App\Models\Contabilidad\ConSubCuenta;

class ConProveedorCuentaController extends Controller
{
    // Listar todas las cuentas proveedor
    public function index()
    {
        return ConProveedorCuenta::with(['proveedor', 'empresa', 'conSubCuenta'])->get();
    }

    // Ver una cuenta específica por ID
    public function show($id)
    {
        $cuenta = ConProveedorCuenta::with(['proveedor', 'empresa', 'conSubCuenta'])->find($id);
        if (!$cuenta) {
            return response()->json(['error' => 'Cuenta no encontrada'], 404);
        }
        return $cuenta;
    }

    // Crear una nueva cuenta proveedor
    public function store(Request $request)
    {
        $request->validate([
            'proveedor_id' => 'required|exists:proveedors,id',
            'con_sub_cuenta_id' => 'required|exists:con_sub_cuentas,id',
            'empresa_id' => 'required|exists:par_empresas,id',
        ]);

        $cuenta = ConProveedorCuenta::create([
            'proveedor_id' => $request->proveedor_id,
            'con_sub_cuenta_id' => $request->con_sub_cuenta_id,
            'par_empresa_id' => $request->empresa_id,
            'estado' => $request->estado ?? 1,
        ]);

        return response()->json($cuenta, 201);
    }

    // Actualizar una cuenta existente
    public function update(Request $request, $id)
    {
        // Si viene tipo_update = 2, buscamos por proveedor_id y empresa_id
        if ($request->tipo_update == 2) {
                $cuenta = ConProveedorCuenta::where('proveedor_id', $request->proveedor_id)
                ->where('par_empresa_id', $request->empresa_id)
                ->first();

            if ($cuenta) {
                // Si existe, lo actualizamos
                $cuenta->update([
                    'con_sub_cuenta_id' => $request->con_sub_cuenta_id,
                    'estado' => $request->estado ?? 1,
                ]);
            } else {
                // Si no existe, lo creamos
                $cuenta = ConProveedorCuenta::create([
                    'proveedor_id' => $request->proveedor_id,
                    'par_empresa_id' => $request->empresa_id,
                    'con_sub_cuenta_id' => $request->con_sub_cuenta_id,
                    'estado' => $request->estado ?? 1,
                ]);
            }

            return response()->json($cuenta);
        }

        // Si no es tipo_update = 2, realizamos un update clásico por ID
        $cuenta = ConProveedorCuenta::find($id);
        if (!$cuenta) {
            return response()->json(['error' => 'Cuenta no encontrada'], 404);
        }

        $cuenta->update($request->only([
            'proveedor_id',
            'con_sub_cuenta_id',
            'empresa_id',
            'estado',
        ]));

        return response()->json($cuenta);
    }


    // Eliminar una cuenta
    public function destroy($id)
    {
        $cuenta = ConProveedorCuenta::find($id);
        if (!$cuenta) {
            return response()->json(['error' => 'Cuenta no encontrada'], 404);
        }

        $cuenta->delete();
        return response()->json(['message' => 'Cuenta eliminada correctamente']);
    }
}

