<?php

namespace App\Http\Controllers\Contabilidad;

use App\Models\Contabilidad\ConRendicion;
use Illuminate\Http\Request;
use App\Models\Contabilidad\ConRendicionDetalle;
use App\Http\Controllers\Controller;

class ConRendicionController extends Controller
{
    public function index()
    {
        $rendiciones = ConRendicion::with('detalles')->get();
        return response()->json($rendiciones);
    }

    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;
        
        if (!$filtro) {
            return response()->json(['error' => 'El filtro de empresa es obligatorio'], 400);
        }
        
        $rendiciones = ConRendicion::with('detalles')
            ->where('empresa_id', $filtro)
            ->get();
            
        return response()->json($rendiciones);
    }

    public function store(Request $request)
    {
        $rendicion = ConRendicion::create([
            'fecha' => $request->fecha,
            'rut_rinde' => $request->rut_rinde,
            'n_rinde' => $request->n_rinde,
            'monto_total' => $request->monto_total,
            'observacion' => $request->observacion,
            'e_pago' => $request->e_pago,
            't_periodo_id' => $request->t_periodo_id,
            'empresa_id' => $request->empresa_id,
            'centralizado' => 0,
        ]);

        if ($request->has('detalles') && is_array($request->detalles)) {
            foreach ($request->detalles as $detalle) {
                ConRendicionDetalle::create([
                    'con_rendicione_id' => $rendicion->id,
                    'doc_tributario_id' => $detalle['doc_tributario_id'],
                    'con_sii_compra_id' => $detalle['con_sii_compra_id'],
                    'razon_social' => $detalle['razon_social'],
                    'folio' => $detalle['folio'],
                    'detalle' => $detalle['detalle'],
                    'monto' => $detalle['monto'],
                    'con_sub_cuenta_id' => $detalle['con_sub_cuenta_id'],
                    'centralizado' => 0,
                    'estado' => 1,
                ]);
            }
        }

        return response()->json($rendicion->load('detalles'), 201);
    }

    public function show(ConRendicion $conRendicion) { }

    public function update(Request $request, ConRendicion $conRendicion) { }

    public function destroy(ConRendicion $conRendicion) { }
}
