<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use App\Models\Contabilidad\ConTVoucher;
use Illuminate\Http\Request;

class ConTVoucherController extends Controller
{
    public function index()
    {
        return ConTVoucher::all();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nombre' => 'required|string|max:100',
            'estado' => 'nullable|integer',
        ]);

        $voucher = ConTVoucher::create($data);

        return response()->json($voucher, 201);
    }

    public function show($id)
    {
        return ConTVoucher::findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $voucher = ConTVoucher::findOrFail($id);

        $voucher->update($request->all());

        return response()->json($voucher);
    }

    public function destroy($id)
    {
        $voucher = ConTVoucher::findOrFail($id);
        $voucher->delete();

        return response()->json(null, 204);
    }
}
