<?php

namespace App\Http\Controllers\Contabilidad;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contabilidad\ConTipoCuenta;

class ConTipoCuentasController extends Controller
{
    public function index()
    {
        return ConTipoCuenta::all();
    }

    public function store(Request $request)
    {
        $request->validate([
            'codigo' => 'required|string|max:100',
            'nombre' => 'required|string|max:100',
            'estado' => 'nullable|integer'
        ]);

        $cuenta = ConTipoCuenta::create([
            'codigo' => $request->codigo,
            'nombre' => $request->nombre,
            'estado' => $request->estado ?? 1
        ]);

        return response()->json($cuenta, 201);
    }

    public function update(Request $request, $id)
    {
        $cuenta = ConTipoCuenta::findOrFail($id);

        $request->validate([
            'codigo' => 'required|string|max:100',
            'nombre' => 'required|string|max:100',
            'estado' => 'nullable|integer'
        ]);

        $cuenta->update([
            'codigo' => $request->codigo,
            'nombre' => $request->nombre,
            'estado' => $request->estado ?? 1
        ]);

        return response()->json($cuenta);
    }

    public function destroy($id)
    {
        $cuenta = ConTipoCuenta::findOrFail($id);
        $cuenta->delete();

        return response()->json(['mensaje' => 'Eliminado correctamente']);
    }
}
