<?php

namespace App\Http\Controllers;
use App\Models\Pos\PosArriendoDetalle;
use Carbon\Carbon;
use App\Models\Pos\PosMDespacho;
use Illuminate\Http\Request;
use App\Models\Pos\PosMantencionDetalle;
use Illuminate\Support\Facades\DB;

class DPanguimaqController extends Controller
{


public function resumenMensual(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;

    if (!$empresaId || !$anio) {
        return response()->json(['error' => 'Faltan filtros necesarios'], 400);
    }

  $resumen = PosArriendoDetalle::whereHas('posArriendo', function ($q) use ($empresaId) {
        $q->where('par_empresa_id', $empresaId);
    })
    ->whereYear('f_salida', $anio)
    ->select(
        DB::raw('MONTH(f_salida) as mes'),
        DB::raw('SUM(v_total) as total')
    )
    ->groupBy(DB::raw('MONTH(f_salida)'))
    ->orderBy(DB::raw('MONTH(f_salida)'))
    ->get();


    // 🔁 Devuelve directamente el número del mes y total
    return response()->json($resumen);
}

public function MesEnCurso(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;
    $mes = $request->mes;

    if (!$empresaId || !$anio || !$mes) {
        return response()->json(['error' => 'Faltan filtros necesarios'], 400);
    }

    $resumen = PosArriendoDetalle::whereHas('posArriendo', function ($q) use ($empresaId) {
        $q->where('par_empresa_id', $empresaId);
    })
    ->whereYear('f_salida', $anio)
    ->whereMonth('f_salida', $mes)
    ->select(
        DB::raw('MONTH(f_salida) as mes'),
        DB::raw('COUNT(*) as cantidad_arriendos'),
        DB::raw('SUM(cantidad) as total_dias'),
        DB::raw('SUM(v_total) as suma_v_total'),
        DB::raw('ROUND(AVG(v_total / cantidad), 2) as promedio_por_dia')
    )
    ->groupBy(DB::raw('MONTH(f_salida)'))
    ->orderBy(DB::raw('MONTH(f_salida)'))
    ->get();

    return response()->json($resumen);
    }


public function MesEnCursoMantencion(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;
    $mes = $request->mes;

    if (!$empresaId) {
        return response()->json(['error' => 'Falta filtro de empresa'], 400);
    }

    // Obtener el RUT de la empresa
    $empresa = \App\Models\Parametros\ParEmpresa::find($empresaId);
    if (!$empresa) {
        return response()->json(['error' => 'Empresa no encontrada'], 404);
    }

    $baseQuery = PosMantencionDetalle::whereHas('posMaquinaria.posCliente', function ($q) use ($empresa) {
        $q->whereNot('rut', $empresa->rut);
    });

    // Siempre obtener posMantenciones activas (estado 1)
    $mantencionesActivas = $baseQuery->where('estado', 1)
        ->select(
            DB::raw('COUNT(*) as cantidad_mantenciones_activas'),
            DB::raw('COUNT(DISTINCT pos_maquinaria_id) as cantidad_maquinarias_unicas'),
            DB::raw('SUM(valor) as suma_valor_total_activas')
        )
        ->first();

    $resultado = [
        'mantenciones_activas' => $mantencionesActivas
    ];

    // Si hay año y mes, agregar resumen mensual
    if ($anio && $mes) {
        $resumenMensual = PosMantencionDetalle::whereHas('posMaquinaria.posCliente', function ($q) use ($empresa) {
            $q->whereNot('rut', $empresa->rut);
        })
        ->whereYear('f_entrada', $anio)
        ->whereMonth('f_entrada', $mes)
        ->where('estado', 0)
        ->select(
            DB::raw('MONTH(f_entrada) as mes'),
            DB::raw('COUNT(*) as cantidad_mantenciones'),
            DB::raw('SUM(valor) as suma_valor_total'),
            DB::raw('ROUND(AVG(valor), 2) as promedio_valor_mantencion')
        )
        ->groupBy(DB::raw('MONTH(f_entrada)'))
        ->orderBy(DB::raw('MONTH(f_entrada)'))
        ->first();

        $resultado['resumen_mensual'] = $resumenMensual;
    }

    return response()->json($resultado);
}

public function MesEnCursoManPropias(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;
    $mes = $request->mes;

    if (!$empresaId) {
        return response()->json(['error' => 'Falta filtro de empresa'], 400);
    }

    // Obtener el RUT de la empresa
    $empresa = \App\Models\Empresa::find($empresaId);
    if (!$empresa) {
        return response()->json(['error' => 'Empresa no encontrada'], 404);
    }

    $baseQuery = PosMantencionDetalle::whereHas('posMaquinaria.posCliente', function ($q) use ($empresa) {
        $q->where('rut', $empresa->rut);
    });

    // Siempre obtener posMantenciones activas (estado 1) de pos_maquinarias propias
    $mantencionesActivas = $baseQuery->where('estado', 1)
        ->select(
            DB::raw('COUNT(*) as cantidad_mantenciones_activas'),
            DB::raw('COUNT(DISTINCT pos_maquinaria_id) as cantidad_maquinarias_unicas'),
            DB::raw('SUM(valor) as suma_valor_total_activas')
        )
        ->first();

    $resultado = [
        'mantenciones_activas' => $mantencionesActivas
    ];

    // Si hay año y mes, agregar resumen mensual de pos_maquinarias propias
    if ($anio && $mes) {
        $resumenMensual = PosMantencionDetalle::whereHas('posMaquinaria.posCliente', function ($q) use ($empresa) {
            $q->where('rut', $empresa->rut);
        })
        ->whereYear('f_entrada', $anio)
        ->whereMonth('f_entrada', $mes)
        ->where('estado', 0)
        ->select(
            DB::raw('MONTH(f_entrada) as mes'),
            DB::raw('COUNT(*) as cantidad_mantenciones'),
            DB::raw('SUM(valor) as suma_valor_total'),
            DB::raw('ROUND(AVG(valor), 2) as promedio_valor_mantencion')
        )
        ->groupBy(DB::raw('MONTH(f_entrada)'))
        ->orderBy(DB::raw('MONTH(f_entrada)'))
        ->first();

        $resultado['resumen_mensual'] = $resumenMensual;
    }

    return response()->json($resultado);
}

public function resumenMensualATmaquinarias(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;

    if (!$empresaId || !$anio) {
        return response()->json(['error' => 'Faltan filtros necesarios'], 400);
    }

    $resumen = PosArriendoDetalle::query()
        ->whereYear('f_salida', $anio)
        ->whereHas('posArriendo', function ($q) use ($empresaId) {
            $q->where('par_empresa_id', $empresaId);
        })
        ->join('pos_maquinarias', 'pos_arriendo_detalles.pos_maquinaria_id', '=', 'pos_maquinarias.id')
        ->join('par_t_maquinarias', 'pos_maquinarias.par_t_maquinaria_id', '=', 'par_t_maquinarias.id')
        ->select(
            DB::raw('MONTH(f_salida) as mes'),
            'par_t_maquinarias.nombre as tipo_maquinaria',
            DB::raw('SUM(v_total) as total')
        )
        ->groupBy(DB::raw('MONTH(f_salida)'), 'par_t_maquinarias.nombre')
        ->orderBy(DB::raw('MONTH(f_salida)'))
        ->get();

    return response()->json($resumen);
}

public function resumenMensualACTmaquinarias(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;

    if (!$empresaId || !$anio) {
        return response()->json(['error' => 'Faltan filtros necesarios'], 400);
    }

    $resumen = PosArriendoDetalle::query()
        ->whereYear('f_salida', $anio)
        ->whereHas('posArriendo', function ($q) use ($empresaId) {
            $q->where('par_empresa_id', $empresaId);
        })
        ->join('pos_maquinarias', 'pos_arriendo_detalles.pos_maquinaria_id', '=', 'pos_maquinarias.id')
        ->join('par_t_maquinarias', 'pos_maquinarias.par_t_maquinaria_id', '=', 'par_t_maquinarias.id')
        ->select(
            DB::raw('MONTH(f_salida) as mes'),
            'par_t_maquinarias.nombre as tipo_maquinaria',
            DB::raw('SUM(cantidad) as total')
        )
        ->groupBy(DB::raw('MONTH(f_salida)'), 'par_t_maquinarias.nombre')
        ->orderBy(DB::raw('MONTH(f_salida)'))
        ->get();

    return response()->json($resumen);
}

public function resumenMensualMantencion(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;

    if (!$empresaId || !$anio) {
        return response()->json(['error' => 'Faltan filtros necesarios'], 400);
    }

  $resumen = PosMDespacho::whereHas('posMantenciones', function ($q) use ($empresaId) {
        $q->where('par_empresa_id', $empresaId);
    })
    ->whereYear('fecha', $anio)
    ->select(
        DB::raw('MONTH(fecha) as mes'),
        DB::raw('SUM(total) as total')
    )
    ->groupBy(DB::raw('MONTH(fecha)'))
    ->orderBy(DB::raw('MONTH(fecha)'))
    ->get();


    // 🔁 Devuelve directamente el número del mes y total
    return response()->json($resumen);
}
public function resumenMensualMantencionTMaquinarias(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;

    if (!$empresaId || !$anio) {
        return response()->json(['error' => 'Faltan filtros necesarios'], 400);
    }

    $resumen = PosMDespacho::with('posMantenciones.posMaquinaria.parTMaquinaria')
        ->whereYear('fecha', $anio)
        ->where('par_empresa_id', $empresaId) // 👈 ahora filtra por m_despachos.par_empresa_id
        ->get()
        ->flatMap(function ($despacho) {
            return $despacho->posMantenciones->map(function ($detalle) use ($despacho) {
                return [
                    'mes' => (int) date('n', strtotime($despacho->fecha)),
                    'tipo_maquinaria' => optional($detalle->posMaquinaria->parTMaquinaria)->nombre ?? 'Sin Tipo',
                    'total' => (int) $despacho->total,
                ];
            });
        })
        ->groupBy(fn ($item) => $item['mes'].'-'.$item['tipo_maquinaria'])
        ->map(function ($items) {
            return [
                'mes' => $items->first()['mes'],
                'tipo_maquinaria' => $items->first()['tipo_maquinaria'],
                'total' => $items->sum('total'),
            ];
        })
        ->values();

    return response()->json($resumen);
}


public function resumenMensualMantencionCTMaquinarias(Request $request)
{
    $empresaId = $request->empresa;
    $anio = $request->anio;

    if (!$empresaId || !$anio) {
        return response()->json(['error' => 'Faltan filtros necesarios'], 400);
    }

    // Carga los despachos con posMantenciones y pos_maquinarias
    $resumen = PosMDespacho::with('posMantenciones.posMaquinaria.parTMaquinaria')
        ->whereYear('fecha', $anio)
        ->where('par_empresa_id', $empresaId)
        ->get()
        ->flatMap(function ($despacho) {
            // Agrupamos por posMaquinaria única dentro de un despacho
            return $despacho->posMantenciones
                ->unique('pos_maquinaria_id')
                ->map(function ($detalle) use ($despacho) {
                    return [
                        'mes' => (int) date('n', strtotime($despacho->fecha)),
                        'tipo_maquinaria' => optional($detalle->posMaquinaria->parTMaquinaria)->nombre ?? 'Sin Tipo',
                    ];
                });
        })
        ->groupBy(fn ($item) => $item['mes'].'-'.$item['tipo_maquinaria'])
        ->map(function ($items) {
            return [
                'mes' => $items->first()['mes'],
                'tipo_maquinaria' => $items->first()['tipo_maquinaria'],
                'total' => $items->count(), // 👈 cantidad de posMantenciones únicas por tipo
            ];
        })
        ->values();

    return response()->json($resumen);
}



}
