<?php

namespace App\Http\Controllers;

use App\Models\DteLog;
use Illuminate\Http\Request;

class DteLogController extends Controller
{
    public function store(Request $request)
    {
        $dteLog = DteLog::create($request->only([
            'cliente_id',
            'dte_id',
            'tipo',
            'xml_envio',
            'xml_respuesta',
            'estado',
            'fecha_envio'
        ]));

        return response()->json(['message' => 'DTE log registrado', 'dte_log' => $dteLog], 201);
    }



    public static function storeLog($venta_id, $mensaje, $cliente_id = null)
    {
        \App\Models\DteLog::create([
            'venta_id' => $venta_id,
            'cliente_id' => $cliente_id,
            'tipo' => 1, // 👈 AGREGA ESTO
            'mensaje' => $mensaje,
            'fecha' => now()
        ]);
    }

}
    