<?php

namespace App\Http\Controllers;

use App\Models\Ingreso;
use Illuminate\Http\Request;

class IngresoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $ingreso = new Ingreso();
        $ingreso->fecha=$request->fecha;
        $ingreso->documento_id=$request->documento_id;
        $ingreso->nro=$request->nro;
        $ingreso->neto=$request->neto;
        $ingreso->impuesto=$request->impuesto;
        $ingreso->total=$request->total;
        $ingreso->usuario_id=$request->usuario_id;
        $ingreso->save();
        if(isset($request->carrito)){
            if(!empty($request->carrito)){
                foreach($request->carrito as $m){
                    $detalle = new \App\Models\DetalleIngreso();
                    $detalle->ingreso_id = $ingreso->id;
                    $detalle->usuario_id = $ingreso->usuario_id;
                    $detalle->fecha = $ingreso->fecha;
                    $detalle->par_empresa_id = $m['empresa_id'] ?? null;
                    $detalle->par_sucursal_id = $m['sucursal_id'] ?? null;
                    $detalle->centro_id = $m['centro_id'] ?? null;
                    $detalle->detalle = $m['texto'] ?? null;
                    $detalle->cantidad = $m['cantidad'] ?? 0;
                    $detalle->neto = $m['neto'] ?? 0;
                    $detalle->precio = $m['precio'] ?? 0;
                    $detalle->total_n = ($detalle->neto) * ($detalle->precio);
                    $detalle->impuesto_p = $m['impuesto_p'] ?? 0;
                    $detalle->impuesto = $detalle->neto * $detalle->impuesto_p;
                    $detalle->total_i = $detalle->impuesto * $detalle->cantidad;
                    $detalle->total = $detalle->total_n + $detalle->total_i;
                    $detalle->save();
                }
            }
        }
        return $this->show($ingreso);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Ingreso  $ingreso
     * @return \Illuminate\Http\Response
     */
    public function show(Ingreso $ingreso)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ingreso  $ingreso
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Ingreso $ingreso)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ingreso  $ingreso
     * @return \Illuminate\Http\Response
     */
    public function destroy(Ingreso $ingreso)
    {
        //
    }
}
