<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;

use App\Models\Parametros\ParCiudad;
use App\Models\Parametros\ParComuna;
use App\Models\Parametros\ParRegion;
use App\Models\Parametros\ParPais;
use Illuminate\Http\Request;

class ParCiudadController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    return ParCiudad::with(['Pais','Region','Comuna'])->orderBy('nombre')->where('estado',1)->get();
    }
    public function Filtro(Request $request)
    {
    return ParCiudad::with(['Pais','Region','Comuna'])->orderBy('nombre')->where('par_comuna_id','=', $request->filtro)->where('estado',1)->get();
    
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $ciudad = new ParCiudad();
        $ciudad->nombre = $request->nombre;
    $ciudad->par_pais_id = $request->pais_id;
    $ciudad->par_region_id = $request->region_id;
    $ciudad->par_comuna_id = $request->comuna_id;
        $ciudad->save();
        return $ciudad;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Ciudad  $ciudad
     * @return \Illuminate\Http\Response
     */
    public function show(ParCiudad $ciudad)
    {
        return $ciudad;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ciudad  $ciudad
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParCiudad $ciudad)
    {
        $ciudad->nombre = $request->nombre;
    $ciudad->par_pais_id = $request->pais_id;
    $ciudad->par_region_id = $request->region_id;
    $ciudad->par_comuna_id = $request->comuna_id;
        $ciudad->save();
        return $ciudad;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ciudad  $ciudad
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParCiudad $ciudad)
    {
        $ciudad->estado = 0;
        $ciudad->save();
    }
}
