<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;

use App\Models\Parametros\ParComuna;
use App\Models\Parametros\ParRegion;
use Illuminate\Http\Request;

class ParComunaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    return ParComuna::with(['Pais','Region'])->orderBy('nombre')->where('estado',1)->get();
    }
    public function Filtro(Request $request)
    {
    return ParComuna::with(['Pais','Region'])->orderBy('nombre')->where('par_region_id','=', $request->filtro)->where('estado',1)->get();
    
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $comuna = new ParComuna();
        $comuna->nombre = $request->nombre;
    $comuna->par_pais_id = $request->pais_id;
    $comuna->par_region_id = $request->region_id;
        $comuna->save();
        return $comuna;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Comuna  $comuna
     * @return \Illuminate\Http\Response
     */
    public function show(ParComuna $comuna)
    {
        return $comuna;
    }
    public function Regioncomuna(ParRegion $region)
    {
        $region->nombre = $region->Nombre;
        $region->comunas = $region->Comunas()->where('estado',1)->get();
        return $region;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Comuna  $comuna
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParComuna $comuna)
    {
        $comuna->nombre = $request->nombre;
    $comuna->par_pais_id = $request->pais_id;
    $comuna->par_region_id = $request->region_id;
        $comuna->save();
        return $comuna;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Comuna  $comuna
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParComuna $comuna)
    {
        $comuna->estado = 0;
        $comuna->save();
    }
}
