<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;

use App\Tb_umedida;
use App\Models\Pos\PosBodega;
use App\Models\Parametros\ParEmpresa as ParEmpresa;
use App\Models\Parametros\ParSucursal as ParSucursal;
use App\Models\UserEmpresa;
use App\Models\UserSucursal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;

class ParEmpresaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $posEmpresas = ParEmpresa::with(['parPais', 'parRegion', 'parComuna', 'parCiudad'])
            ->where('estado', 1)
            ->get()
            ->map(function ($e) {
                /** @var \App\Models\Parametros\ParEmpresa $e */
                try {
                    $e->sii = Crypt::decryptString($e->sii);
                } catch (\Exception $ex) {
                    $e->sii = null;
                }
                return $e;
            });


        return $posEmpresas;
    }


    public function filtro(Request $request)
    {
        $filtro = $request->filtro;

        $parEmpresa = ParEmpresa::leftjoin('par_empresas', 'user_empresas.par_empresa_id', '=', 'par_empresas.id')->select('id')
            ->get();
        return ['par_empresa' => $parEmpresa];
    }
    public function filtroLibro(Request $request)
    {
        $filtro = $request->filtro;
        return ParEmpresa::with(['parPais', 'parRegion', 'parComuna', 'parCiudad'])->where('id', $filtro)->where('estado', 1)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // Limpiar RUT: eliminar puntos y guión
        $rutLimpio = str_replace(['.', '-'], '', $request->rut);

        // Crear empresa
        $parEmpresa = new ParEmpresa();
        $parEmpresa->nombre = $request->nombre;
        $parEmpresa->rut = $rutLimpio;
        $parEmpresa->razon_social = $request->razon_social;
        $parEmpresa->par_pais_id = $request->par_pais_id;
        $parEmpresa->par_region_id = $request->par_region_id;
        $parEmpresa->par_comuna_id = $request->par_comuna_id;
        $parEmpresa->par_ciudad_id = $request->par_ciudad_id;
        $parEmpresa->direccion = $request->direccion;
        $parEmpresa->sii = Crypt::encryptString($request->sii);
        $parEmpresa->ppm = $request->ppm;
        $parEmpresa->giro = $request->giro;
        $parEmpresa->save();

        // Asociar empresa al usuario que creó
        $userEmpresa = new UserEmpresa();
        $userEmpresa->user_id = $request->user_id;
        $userEmpresa->par_empresa_id = $parEmpresa->id;
        $userEmpresa->save();

        // Crear sucursal "Principal"
        $parSucursal = new ParSucursal();
        $parSucursal->nombre = 'Principal';
        $parSucursal->direccion = $request->direccion;
        $parSucursal->telefono = $request->telefono ?? null;
        $parSucursal->par_empresa_id = $parEmpresa->id;
        $parSucursal->par_pais_id = $request->par_pais_id;
        $parSucursal->par_region_id = $request->par_region_id;
        $parSucursal->par_comuna_id = $request->par_comuna_id;
        $parSucursal->par_ciudad_id = $request->par_ciudad_id;
        $parSucursal->save();

        // Crear bodega asociada a la nueva sucursal
        $posBodega = new posBodega();
        $posBodega->nombre = $request->nombre; // Puedes cambiar esto a otro valor si lo deseas, como "Bodega Principal"
        $posBodega->par_empresa_id = $parEmpresa->id;
        $posBodega->par_sucursal_id = $parSucursal->id;
        $posBodega->save();

        // Asociar sucursal al usuario que creó
        $userSucursal = new UserSucursal();
        $userSucursal->user_id = $request->user_id;
        $userSucursal->par_empresa_id = $parEmpresa->id;
        $userSucursal->par_sucursal_id = $parSucursal->id;
        $userSucursal->save();

        // Crear cliente por defecto para boleta en ven_clientes
        DB::table('ven_clientes')->insert([
            'nombre' => 'Cliente Boleta',
            'rut' => '11111111',
            'par_empresa_id' => $parEmpresa->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Asociar empresa y sucursal a todos los usuarios con rol_id 1 o 2
        $usuarios = DB::table('users')->whereIn('rol_id', [1, 2])->get();

        foreach ($usuarios as $usuario) {
            // Asociar empresa si no existe
            $existeEmpresa = DB::table('user_empresas')
                ->where('user_id', $usuario->id)
                ->where('par_empresa_id', $parEmpresa->id)
                ->exists();

            if (!$existeEmpresa) {
                DB::table('user_empresas')->insert([
                    'user_id' => $usuario->id,
                    'par_empresa_id' => $parEmpresa->id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            // Asociar sucursal si no existe
            $existeSucursal = DB::table('user_sucursals')
                ->where('user_id', $usuario->id)
                ->where('par_empresa_id', $parEmpresa->id)
                ->where('par_sucursal_id', $parSucursal->id)
                ->exists();

            if (!$existeSucursal) {
                DB::table('user_sucursals')->insert([
                    'user_id' => $usuario->id,
                    'par_empresa_id' => $parEmpresa->id,
                    'par_sucursal_id' => $parSucursal->id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }

        // Replicar datos de empresa_id = 1 en las 5 tablas contables
        $tablas = [
            'con_cuenta_generals',
            'con_cuenta_sii_compras',
            'con_cuenta_sii_h_compras',
            'con_cuenta_sii_h_ventas',
            'con_cuenta_sii_ventas',
            'con_impuesto_cuentas',
        ];

        foreach ($tablas as $tabla) {
            $registros = DB::table($tabla)->where('par_empresa_id', 1)->get();

            foreach ($registros as $registro) {
                $nuevo = (array) $registro;
                unset($nuevo['id']);
                $nuevo['par_empresa_id'] = $parEmpresa->id;
                DB::table($tabla)->insert($nuevo);
            }
        }

        return response()->json([
            'empresa' => $parEmpresa,
            'sucursal' => $parSucursal,
            'bodega' => $posBodega
        ]);
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Parametros\ParEmpresa  $parEmpresa
     * @return \Illuminate\Http\Response
     */
    public function show(ParEmpresa $parEmpresa)
    {

        $parEmpresa->parPais = $parEmpresa->parPais;
        $parEmpresa->parRegion = $parEmpresa->parRegion;
        $parEmpresa->parComuna = $parEmpresa->parComuna;
        $parEmpresa->parCiudad = $parEmpresa->parCiudad;
        return $parEmpresa;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Parametros\ParEmpresa  $parEmpresa
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParEmpresa $parEmpresa)
    {
        // Eliminar puntos y guiones del RUT
        $rutLimpio = preg_replace('/[^0-9kK]/', '', $request->rut);

        $parEmpresa->nombre = $request->nombre;
        $parEmpresa->rut = $rutLimpio;
        $parEmpresa->razon_social = $request->razon_social;
        $parEmpresa->par_pais_id = $request->par_pais_id;
        $parEmpresa->par_region_id = $request->par_region_id;
        $parEmpresa->par_comuna_id = $request->par_comuna_id;
        $parEmpresa->par_ciudad_id = $request->par_ciudad_id;
        $parEmpresa->direccion = $request->direccion;
        $parEmpresa->sii = Crypt::encryptString($request->sii);
        $parEmpresa->ppm = $request->ppm;
        $parEmpresa->giro = $request->giro;
        $parEmpresa->save();

        return $parEmpresa;
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Parametros\ParEmpresa  $parEmpresa
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParEmpresa $parEmpresa)
    {
        $parEmpresa->estado = 0;
        $parEmpresa->save();
    }
}
