<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;


use App\Models\Parametros\ParMarca;
use Illuminate\Http\Request;

class ParMarcaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ParMarca::where('estado',1)->orderBy('nombre','asc')->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $parMarca = new ParMarca();
        $parMarca->nombre = $request->nombre;
        $parMarca->save();
        return $parMarca;

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ParMarca  $parMarca
     * @return \Illuminate\Http\Response
     */
    public function show(ParMarca $parMarca)
    {
        return $parMarca;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ParMarca  $parMarca
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParMarca $parMarca)
    {
        $parMarca->nombre = $request->nombre;
        $parMarca->save();
        return $parMarca;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ParMarca  $parMarca
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParMarca $parMarca)
    {
        $parMarca->estado = 0;
        $parMarca->save();

    }
}
