<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;


use App\Models\Parametros\ParMedida;
use Illuminate\Http\Request;

class ParMedidaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ParMedida::where('estado',1)->orderBy('nombre')->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $parMedida = new ParMedida();
        $parMedida->nombre = $request->nombre;
        $parMedida->codigo = $request->codigo;
        $parMedida->save();
        return $parMedida;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ParMedida  $parMedida
     * @return \Illuminate\Http\Response
     */
    public function show(ParMedida $parMedida)
    {
        
        return $parMedida;

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ParMedida  $parMedida
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParMedida $parMedida)
    {
        $parMedida->nombre = $request->nombre;
        $parMedida->codigo = $request->codigo;
        $parMedida->save();
        return $parMedida;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ParMedida  $parMedida
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParMedida $parMedida)
    {
        $parMedida->estado = 0;
        $parMedida->save();
    }
}
