<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;

use App\Models\Parametros\ParPais;
use Illuminate\Http\Request;

class ParPaisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ParPais::where('estado',1)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    $pais = new ParPais();
    $pais->nombre = $request->nombre;
    $pais->save();
    return $pais;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Pais  $pais
     * @return \Illuminate\Http\Response
     */
    public function show(ParPais $pais)
    {
        return $pais;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Pais  $pais
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParPais $pais)
    {
        $pais->nombre = $request->nombre;
        $pais->save();
        return $pais;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Pais  $pais
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParPais $pais)
    {
        $pais->estado = 0;
        $pais->save();
    }
}
