<?php
namespace App\Http\Controllers\Parametros;

use App\Models\CFDetalle;


use App\Models\CFPeriodo;
use App\Models\Parametros\ParPeriodo;
use App\Models\CFormulario;
use Illuminate\Http\Request;
use App\Models\TImpAutomatico;
use App\Models\TGRemuneracione;
use App\Models\TRemuAutomatico;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Parametros\ParEmpresa;

class ParPeriodoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ParPeriodo::with(['parAnio', 'parMese'])->where('estado', 1)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
            $parPeriodo = ParPeriodo::create([
                'nombre' => $request->nombre,
                'par_mese_id' => $request->par_mese_id ?? $request->mese_id,
                'par_anio_id' => $request->par_anio_id ?? $request->anio_id ?? $request->ano_id,
                'mes_ano' => $request->mes_ano,
            ]);

            return response()->json($parPeriodo, 201);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ParPeriodo  $parPeriodo
     * @return \Illuminate\Http\Response
     */
    public function show(ParPeriodo $parPeriodo)
    {
        $parPeriodo->load(['parAnio', 'parMese']);
        return response()->json($parPeriodo, 200);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ParPeriodo  $parPeriodo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParPeriodo $parPeriodo)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
        ]);

        $parPeriodo->update($request->all());
        return response()->json($parPeriodo, 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ParPeriodo  $parPeriodo
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParPeriodo $parPeriodo)
    {
        $parPeriodo->update(['estado' => 0]);
        return response()->json(['message' => 'Registro desactivado correctamente'], 200);
    }
}
