<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;
use App\Models\Parametros\ParPeriodoEmpresa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class ParPeriodoEmpresaController extends Controller
{
    public function index()
    {
        $cacheKey = 'par_periodo_empresas_all';

        return Cache::remember($cacheKey, now()->addMinutes(5), function () {
            return ParPeriodoEmpresa::with(['ParPeriodo', 'ParPeriodo.parAno', 'ParPeriodo.parMese'])->get();
        });
    }

    public function Filtro(Request $request)
    {
        $empresaId = $request->filtro;
        $cacheKey = "par_periodo_empresas_empresa_{$empresaId}";

        return Cache::remember($cacheKey, now()->addMinutes(5), function () use ($empresaId) {
            return ParPeriodoEmpresa::with(['parPeriodo', 'parPeriodo.parAnio', 'parPeriodo.parMese'])
                ->where('par_empresa_id', $empresaId)
                ->get();
        });
    }

    public function filtroActivo(Request $request)
    {
        $empresaId = $request->filtro;
        $cacheKey = "par_periodo_empresas_activos_empresa_{$empresaId}";

        return Cache::remember($cacheKey, now()->addMinutes(5), function () use ($empresaId) {
            return ParPeriodoEmpresa::with(['parPeriodo', 'parPeriodo.parAnio', 'parPeriodo.parMese'])
                ->where('par_empresa_id', $empresaId)
                ->get();
        });
    }

    public function store(Request $request)
    {
        $nuevo = ParPeriodoEmpresa::create([
            // aceptar par_periodo_id o t_periodo_id según lo que envíe el cliente
            'par_periodo_id' => $request->par_periodo_id ?? $request->par_periodo_id,
            'par_empresa_id' => $request->par_empresa_id,
            'estado' => 1,
        ]);

        $this->clearEmpresaCache($request->par_empresa_id);

        return $nuevo;
    }

    public function update(Request $request, ParPeriodoEmpresa $parPeriodoEmpresa)
    {
        $parPeriodoEmpresa->estado = $request->estado;
        $parPeriodoEmpresa->save();

        $this->clearEmpresaCache($parPeriodoEmpresa->par_empresa_id);

        return $parPeriodoEmpresa;
    }

    public function destroy(ParPeriodoEmpresa $parPeriodoEmpresa)
    {
        $empresaId = $parPeriodoEmpresa->par_empresa_id;
        $parPeriodoEmpresa->estado = 0;
        $parPeriodoEmpresa->save();

        $this->clearEmpresaCache($empresaId);

        return response()->json(['message' => 'Periodo marcado como inactivo']);
    }

    private function clearEmpresaCache($empresaId)
    {
        Cache::forget('par_periodo_empresas_all');
        Cache::forget("par_periodo_empresas_empresa_{$empresaId}");
        Cache::forget("par_periodo_empresas_activos_empresa_{$empresaId}");
    }
}
