<?php
namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;

use App\Models\Parametros\ParRegion;
use App\Models\Parametros\ParPais;
use Illuminate\Http\Request;

class ParRegionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    return ParRegion::with(['Pais'])->orderBy('nombre')->where('estado',1)->get();
    
    }
    public function Filtro(Request $request)
    {
    return ParRegion::with(['Pais'])->orderBy('nombre')->where('par_pais_id','=', $request->filtro)->where('estado',1)->get();
    
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    $region = new ParRegion();
        $region->nombre = $request->nombre;
        $region->par_pais_id = $request->pais_id;
        $region->save();
        return $region;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function show(ParRegion $region)
    {
        return $region;
    }

    public function Regionpais(ParPais $pais)
     {
         $pais->nombre = $pais->Nombre;
         $pais->regiones = $pais->Regiones()->where('estado',1)->get();
         return $pais;
     }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParRegion $region)
    {
        /** @var \App\Models\Parametros\ParRegion $region */
        $region->nombre = $request->nombre;
    $region->par_pais_id = $request->pais_id;
        $region->save();
        return $region;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParRegion $region)
    {
        /** @var \App\Models\Parametros\ParRegion $region */
        $region->estado = 0;
        $region->save();
    }
}
