<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;
use App\Models\Parametros\ParRepresentante;
use App\Models\Parametros\ParEmpresa as ParEmpresa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class ParRepresentanteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    $parRepresentantes = ParRepresentante::with(['parEmpresa'])
    ->where('estado', 1)
    ->orderBy('p_nombre')
    ->get()
    ->map(function ($r) {
        try {
            $r->c_sii = Crypt::decryptString($r->c_sii);
        } catch (\Exception $e) {
            $r->c_sii = null; // o "********"
        }

        try {
            $r->c_unica = Crypt::decryptString($r->c_unica);
        } catch (\Exception $e) {
            $r->c_unica = null;
        }

        return $r;
    });

return $parRepresentantes;
    }

         public function Filtro(Request $request)
{
    $filtro = $request->filtro;

    return ParRepresentante::with('parEmpresa')
    ->where('par_empresa_id', $filtro)
     ->where('estado', 1)
    ->orderBy('p_nombre')
    ->get()
    ->map(function ($r) {
        try {
            $r->c_sii = Crypt::decryptString($r->c_sii);
        } catch (\Exception $e) {
            $r->c_sii = null; // o "********"
        }

        try {
            $r->c_unica = Crypt::decryptString($r->c_unica);
        } catch (\Exception $e) {
            $r->c_unica = null;
        }

        return $r;
    });

return $parRepresentantes;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $parRepresentante = new ParRepresentante();
        $parRepresentante->par_empresa_id = $request->par_empresa_id;
        $parRepresentante->rut = $request->rut;
        $parRepresentante->p_nombre = $request->p_nombre;
        $parRepresentante->s_nombre = $request->s_nombre;
        $parRepresentante->a_paterno = $request->a_paterno;
        $parRepresentante->a_materno = $request->a_materno;
        $parRepresentante->par_pais_id = $request->par_pais_id;
        $parRepresentante->par_region_id = $request->par_region_id;
        $parRepresentante->par_comuna_id = $request->par_comuna_id;
        $parRepresentante->par_ciudad_id = $request->par_ciudad_id;
        $parRepresentante->direccion = $request->direccion;
        $parRepresentante->telefono = $request->telefono;
        $parRepresentante->email = $request->email;
        $parRepresentante->c_sii = Crypt::encryptString($request->c_sii);
        $parRepresentante->c_unica = Crypt::encryptString($request->c_unica);
        $parRepresentante->save();
        return $parRepresentante;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ParRepresentante  $parRepresentante
     * @return \Illuminate\Http\Response
     */
    public function show(ParRepresentante $parRepresentante)
    {
        return $parRepresentante;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ParRepresentante  $parRepresentante
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParRepresentante $parRepresentante)
    {
        $parRepresentante->rut = $request->rut;
        $parRepresentante->p_nombre = $request->p_nombre;
        $parRepresentante->s_nombre = $request->s_nombre;
        $parRepresentante->a_paterno = $request->a_paterno;
        $parRepresentante->a_materno = $request->a_materno;
        $parRepresentante->telefono = $request->telefono;
        $parRepresentante->par_pais_id = $request->par_pais_id;
        $parRepresentante->par_region_id = $request->par_region_id;
        $parRepresentante->par_comuna_id = $request->par_comuna_id;
        $parRepresentante->par_ciudad_id = $request->par_ciudad_id;
        $parRepresentante->direccion = $request->direccion;
        $parRepresentante->email = $request->email;
        $parRepresentante->c_sii = Crypt::encryptString($request->c_sii);
        $parRepresentante->c_unica = Crypt::encryptString($request->c_unica);
        $parRepresentante->save();
        return $parRepresentante;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ParRepresentante  $parRepresentante
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParRepresentante $parRepresentante)
    {
        $parRepresentante->estado = 0;
        $parRepresentante->save();
        return $parRepresentante;
    }
}
