<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;
use App\Models\Parametros\ParSocio;
use App\Models\Parametros\ParEmpresa as ParEmpresa;
use Illuminate\Http\Request;

class ParSocioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ParSocio::with(['parEmpresa'])->orderBy('p_nombre')->where('estado', 1)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $parSocio = new ParSocio();
        $parSocio->par_empresa_id = $request->par_empresa_id;
        $parSocio->p_nombre = $request->p_nombre;
        $parSocio->s_nombre = $request->s_nombre;
        $parSocio->a_paterno = $request->a_paterno;
        $parSocio->a_materno = $request->a_materno;
        $parSocio->par_pais_id = $request->par_pais_id;
        $parSocio->par_region_id = $request->par_region_id;
        $parSocio->par_comuna_id = $request->par_comuna_id;
        $parSocio->par_ciudad_id = $request->par_ciudad_id;
        $parSocio->direccion = $request->direccion;
        $parSocio->participacion = $request->participacion;
        $parSocio->telefono = $request->telefono;
        $parSocio->email = $request->email;
        $parSocio->participacion = $request->participacion;
        $parSocio->save();
        return $parSocio;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TSocio  $parSocio
     * @return \Illuminate\Http\Response
     */
    public function show(ParSocio $parSocio)
    {
        return $parSocio;
    }

    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;

        return ParSocio::with('parEmpresa')
            ->where('par_empresa_id', $filtro)
            ->where('estado', 1)
            ->get();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TSocio  $parSocio
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParSocio $parSocio)
    {
        $parSocio->p_nombre = $request->p_nombre;
        $parSocio->s_nombre = $request->s_nombre;
        $parSocio->a_paterno = $request->a_paterno;
        $parSocio->a_materno = $request->a_materno;
        $parSocio->par_pais_id = $request->par_pais_id;
        $parSocio->par_region_id = $request->par_region_id;
        $parSocio->par_comuna_id = $request->par_comuna_id;
        $parSocio->par_ciudad_id = $request->par_ciudad_id;
        $parSocio->direccion = $request->direccion;
        $parSocio->participacion = $request->participacion;
        $parSocio->telefono = $request->telefono;
        $parSocio->email = $request->email;
        $parSocio->participacion = $request->participacion;
        $parSocio->save();
        return $parSocio;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TSocio  $parSocio
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParSocio $parSocio)
    {
        $parSocio->estado = 0;
        $parSocio->save();
        return $parSocio;
    }
}
