<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;
use App\Models\Parametros\ParSucursal;
use App\Models\UserSucursal;
use Illuminate\Http\Request;

class ParSucursalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ParSucursal::with(['parPais', 'parRegion', 'parComuna', 'parCiudad', 'parEmpresa'])->where('estado', 1)->get();
    }

    public function Empresa(Request $request)
    {
        $empresaParam = $request->get('empresa');

        // Convertir "1,2,3" en array [1,2,3]
        $empresaIds = explode(',', $empresaParam);

        return ParSucursal::with(['parPais', 'parRegion', 'parComuna', 'parCiudad', 'parEmpresa'])
            ->where('estado', 1)
            ->whereIn('par_empresa_id', $empresaIds) 
            ->get();
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $parSucursal = new ParSucursal();
        $parSucursal->nombre = $request->nombre;
        $parSucursal->direccion = $request->direccion;
        $parSucursal->telefono = $request->telefono;
        $parSucursal->par_empresa_id = $request->par_empresa_id;
        $parSucursal->par_pais_id = $request->par_pais_id;
        $parSucursal->par_region_id = $request->par_region_id;
        $parSucursal->par_comuna_id = $request->par_comuna_id;
        $parSucursal->par_ciudad_id = $request->par_ciudad_id;
        $parSucursal->save();
        $userSucursal = new UserSucursal();
        $userSucursal->user_id = 1;
        $userSucursal->par_empresa_id = $request->par_empresa_id;
        $userSucursal->par_sucursal_id = $parSucursal->id;
        $userSucursal->save();
        return $parSucursal;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Parametros\ParSucursal  $parSucursal
     * @return \Illuminate\Http\Response
     */
    public function show(ParSucursal $parSucursale)
    {
        $parSucursale->parEmpresa = $parSucursale->parEmpresa;
        $parSucursale->parPais = $parSucursale->parPais;
        $parSucursale->parRegion = $parSucursale->parRegion;
        $parSucursale->parComuna = $parSucursale->parComuna;
        $parSucursale->parCiudad = $parSucursale->parCiudad;
        return $parSucursale;
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Parametros\ParSucursal  $parSucursal
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParSucursal $parSucursale)
    {
        $parSucursale->nombre = $request->nombre;
        $parSucursale->direccion = $request->direccion;
        $parSucursale->telefono = $request->telefono;
        $parSucursale->par_pais_id = $request->par_pais_id;
        $parSucursale->par_region_id = $request->par_region_id;
        $parSucursale->par_comuna_id = $request->par_comuna_id;
        $parSucursale->par_ciudad_id = $request->par_ciudad_id;
        $parSucursale->save();
        return $parSucursale;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Parametros\ParSucursal  $parSucursal
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParSucursal $parSucursal)
    {
        //
    }
}
