<?php

namespace App\Http\Controllers\Parametros;

use App\Http\Controllers\Controller;

use App\Models\Parametros\ParTMaquinaria;
use Illuminate\Http\Request;

class ParTMaquinariaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ParTMaquinaria::where('estado',1)->get();
    }
   public function Filtro(Request $request)

    
    {
        $filtro = $request->filtro;
        $cliente = $request->cliente;
        return ParTMaquinaria::where('empresa_id', $filtro)
                            ->where('ven_cliente_id', $cliente)
                            ->where('estado',1)
                            ->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $parTMaquinaria = new ParTMaquinaria();
        $parTMaquinaria->nombre = $request->nombre;
        $parTMaquinaria->save();
        return $parTMaquinaria;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ParTMaquinaria  $parTMaquinaria
     * @return \Illuminate\Http\Response
     */
    public function show(ParTMaquinaria $parTMaquinaria)
    {
        return $parTMaquinaria;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ParTMaquinaria  $parTMaquinaria
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ParTMaquinaria $parTMaquinaria)
    {
        $parTMaquinaria->nombre = $request->nombre;
        $parTMaquinaria->save();
        return $parTMaquinaria;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ParTMaquinaria  $parTMaquinaria
     * @return \Illuminate\Http\Response
     */
    public function destroy(ParTMaquinaria $parTMaquinaria)
    {
        $parTMaquinaria->estado = 0;
        $parTMaquinaria->save();
    }
}
