<?php

namespace App\Http\Controllers\Pos;

use Carbon\Carbon;
use App\Models\Pos\PosMaquinaria;
use Illuminate\Http\Request;
use App\Models\Pos\PosARecepcione;
use App\Models\Pos\ArriendoDetalle;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Pos\PosArriendoDetalle;
use App\Http\Controllers\Controller;

class PosARecepcioneController extends Controller
{
    public function index()
    {
        return PosARecepcione::with(['posCliente', 'posArriendoDetalle.posMaquinaria','posArriendoDetalle.posMaquinaria.parMarca'])
        ->where('estado', 1)
        ->orderBy('fecha', 'desc')
        ->get();
    }

    public function store(Request $request)
    {
        $arriendo = new PosARecepcione();
        $arriendo->pos_cliente_id = $request->pos_cliente_id;
        $arriendo->par_empresa_id = $request->par_empresa_id;
        $arriendo->recepciona = $request->recepciona;
        $arriendo->fecha = Carbon::parse($request->fecha)->format('Y-m-d');
        $arriendo->save();

        if (!empty($request->detalle)) {
            foreach ($request->detalle as $m) {
                $detalle = PosArriendoDetalle::where('id', $m['id'])->first();

                if ($detalle) {
                    $f_entrada = Carbon::parse($detalle->f_entrada);
                    $f_salida = Carbon::parse($arriendo->fecha);
                    $t_dias = $f_entrada->diffInDays($f_salida) + 1;
                    $d_descuento = isset($m['d_descuento']) ? $m['d_descuento'] : $detalle->d_descuento;
                    $t_arriendo = ($detalle->t_dias * $detalle->valor) - $d_descuento;

                    $detalle->update([
                        'f_salida' => $f_salida->format('Y-m-d'),
                        'pos_a_recepcione_id' => $arriendo->id,
                        'cantidad' => $m['t_dias'],
                        'd_descuento' => $m['d_descuento'],
                        'v_total' => $m['t_arriendo'],
                        'estado' => 0,
                    ]);
                }

                PosMaquinaria::where('id', $m['pos_maquinaria_id'])->update(['pos_estatu_id' => 1]);
            }
        }
        return response()->json([
            'message' => 'Arriendo registrado con éxito',
            'id' => $arriendo->id,
        ], 201);
    }

    public function show(PosARecepcione $posARecepcione)
    {
        return $posARecepcione;
    }

    public function update(Request $request, PosARecepcione $posARecepcione)
    {
        // ...existing code...
    }

    public function destroy(PosARecepcione $posARecepcione)
    {
        // ...existing code...
    }

    public function pdfrecepcion(PosARecepcione $posARecepcione)
    {
        $pdf = PDF::loadView('reports.arriendo', compact('posARecepcione'));
        return $pdf->stream();
    }

    public function imprimirTicket($id)
    {
        $posArriendo = PosARecepcione::with('posCliente', 'posArriendoDetalle.posMaquinaria')->findOrFail($id);

        $pdf = Pdf::loadView('reports.arriendo', compact('posArriendo'))
            ->setPaper([0, 0, 226.77, 1000]);

        return response($pdf->output(), 200)
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'inline; filename="ticket.pdf"');
    }

}
