<?php

namespace App\Http\Controllers\Pos;

use App\Models\Pos\PosMaquinaria;
use App\Models\Pos\PosArriendo;
use Illuminate\Http\Request;
use App\Models\Pos\PosArriendoDetalle;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;

class PosArriendoController extends Controller
{
    public function index()
    {
        return PosArriendo::with(['posCliente', 'PosArriendoDetalle.posMaquinaria','PosArriendoDetalle.posMaquinaria.parMarca'])
    ->where('estado', 1)
    ->orderBy('fecha', 'desc') // Orden ascendente por fecha
    ->get();
    }

    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;

        return PosArriendo::with(['posCliente'])
        ->where('pos_estatu_id', $filtro)
        ->where('estado', 1)
        ->orderBy('fecha', 'asc') // Orden ascendente por fecha
        ->get();
    }

    public function Filtro2(Request $request)
{
    $filtro = $request->filtro;

    return PosArriendo::with(['posCliente', 'pos_arriendo_detalles']) // 👈 se agrega la relación
        ->where('par_empresa_id', $filtro)
        ->where('estado', 1)
        ->orderBy('fecha', 'asc')
        ->get();
}

    public function store(Request $request)
{
    // Crear un nuevo registro de Arriendo
    $posArriendo = new PosArriendo();
    $posArriendo->pos_cliente_id = $request->pos_cliente_id;
    $posArriendo->par_empresa_id = $request->par_empresa_id;
    $posArriendo->retira = $request->retira;
    $posArriendo->fecha = $request->fecha;
    $posArriendo->save(); // Guardar el registro para generar el ID

    // Verificar si existen detalles en la solicitud
    if (isset($request->detalle) && !empty($request->detalle)) {
        foreach ($request->detalle as $m) {
            // Crear un nuevo registro de detalle
            $detalle = new PosArriendoDetalle();
            $detalle->pos_maquinaria_id = $m['pos_maquinaria_id'];
            $detalle->valor = $m['v_arriendo'];
            $detalle->pos_arriendo_id = $posArriendo->id; // Usar el ID recién generado
            $detalle->f_entrada = $posArriendo->fecha;
            $detalle->save(); // Guardar el detalle

            // Actualizar el pos_estatu_id de la maquinaria
            PosMaquinaria::where('id', $m['pos_maquinaria_id'])->update(['pos_estatu_id' => 2]);
        }
    }

    return response()->json([
        'message' => 'Arriendo registrado con éxito',
        'id' => $posArriendo->id, // 🔥 Agregamos el ID del posArriendo en la respuesta
    ], 201);
}

    public function show(PosArriendo $posArriendo)
    {
        $posArriendo->cliente = $posArriendo->cliente;
    }

    public function update(Request $request, PosArriendo $posArriendo)
    {
        //
    }

    public function destroy(PosArriendo $posArriendo)
    {
        $posArriendo->estado = 0;
        $posArriendo->save();
    }


public function imprimirTicket($id)
{
    $posArriendo = PosArriendo::with('posCliente', 'posArriendoDetalle.posMaquinaria')->findOrFail($id);

    $pdf = Pdf::loadView('reports/arriendoe', compact('posArriendo'))
        ->setPaper([0, 0, 226.77, 1000]); // 80 mm de ancho

    return response($pdf->output(), 200)
        ->header('Content-Type', 'application/pdf')
        ->header('Content-Disposition', 'inline; filename="ticket.pdf"');
}

}
