<?php

namespace App\Http\Controllers\Pos;

use App\Http\Controllers\Controller;
use App\Models\Pos\PosArriendoDetalle;
use App\Models\Pos\parMarca;
use Illuminate\Http\Request;

class PosArriendoDetalleController extends Controller
{
    public function index()
    {
        return PosArriendoDetalle::with(['posMaquinaria','posMaquinaria.parMarca'])->where('estado',1)->get();
    }
    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;
        return PosArriendoDetalle::with(['posMaquinaria','posMaquinaria.parMarca'])->where('pos_arriendo_id', $filtro)->get();
    }
    public function Filtro1(Request $request)
    {
        $filtro = $request->filtro;
        return PosArriendoDetalle::with(['posMaquinaria','posMaquinaria.parMarca'])->where('pos_a_recepcione_id', $filtro)->get();
    }
    public function Filtro2(Request $request)
    {
        $filtro = $request->filtro;
        return PosArriendoDetalle::with(['posMaquinaria', 'posMaquinaria.parMarca', 'posArriendo'])
        ->whereHas('posArriendo', function ($query) use ($filtro) {
            $query->where('pos_cliente_id', $filtro);
        })
        ->where('estado', 1)
        ->get();
    }

    public function store(Request $request)
    {
        // Implementación si es necesaria
    }

    public function show(PosArriendoDetalle $posArriendoDetalle)
    {
        //
    }

    public function update(Request $request, PosArriendoDetalle $posArriendoDetalle)
    {
        //
    }

    public function destroy(PosArriendoDetalle $posArriendoDetalle)
    {
        //
    }
}
