<?php

namespace App\Http\Controllers\Pos;

use App\Models\Pos\PosBodega;
use App\Models\Pos\PosArticulo;
use App\Models\Pos\PosBodegaArticulo;
use Illuminate\Http\Request;
use PhpParser\Node\Expr\PostDec;
use Illuminate\Routing\Controller;

class PosBodegaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    return PosBodega::with(['parEmpresa','parSucursal'])->where('estado',1)->get();
    }

    public function Bodega(Request $request)
    {
        $par_sucursal_id = $request->par_sucursal_id;
    return PosBodega::with(['parEmpresa','parSucursal'])->where('estado',1)->where('par_sucursal_id',$par_sucursal_id)->get();
    }

    public function BodegaEmpresa(Request $request)
    {
        $empresa= $request->empresa;
    return PosBodega::with(['parEmpresa','parSucursal'])->where('estado',1)->where('par_empresa_id',$empresa)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
{
    // 1. Crear la bodega
    $posBodega = new PosBodega();
    $posBodega->nombre = $request->nombre;
    $posBodega->par_empresa_id = $request->empresa_id;
    $posBodega->par_sucursal_id = $request->sucursal_id;
    $posBodega->direccion = $request->direccion;
    $posBodega->save();

    // 2. Obtener todos los artículos existentes
    $articulos = PosArticulo::where('par_empresa_id', $request->empresa_id)->get();

    // 3. Crear un registro en bodega_articulos por cada artículo
    foreach ($articulos as $articulo) {
            PosBodegaArticulo::create([
            'pos_articulo_id' => $articulo->id,
            'pos_bodega_id' => $posBodega->id,
            'stock' => 0,
            'c_stock' => $articulo->c_stock ?? '1', // Si usas campo directo en Articulo, o reemplaza si no existe
            'c_unitario' => 0,
            'p_venta' => $articulo->venta ?? 0,
            'costo' => 0,
                'par_empresa_id' => $posBodega->par_empresa_id,
                'par_sucursal_id' => $posBodega->par_sucursal_id,
        ]);
    }

    return $posBodega;
}


    public function show(PosBodega $posbodega)
    {
        $posbodega->empresa = $posbodega->Empresa;
        $posbodega->sucursal = $posbodega->Sucursal;
        return $posbodega;
    }

    public function update(Request $request, PosBodega $posBodega)
    {
    $posBodega->nombre = $request->nombre;
    $posBodega->par_sucursal_id = $request->sucursal_id;
        $posBodega->direccion = $request->direccion;
        $posBodega->save();
        return $posBodega;
    }

    public function destroy(PosBodega $posBodega)
    {
        $posBodega->estado = 0;
        $posBodega->save();
    }
}
