<?php

namespace App\Http\Controllers\Pos;

use App\Models\Pos\PosCaja;
use Illuminate\Http\Request;
use App\Models\Pos\PosCajaMovimiento;
use Illuminate\Routing\Controller;

class PosCajaController extends Controller
{
    public function index()
    {
        return PosCaja::where('estado',1)->get();
    }

    public function cajaActiva($user_id)
    {
        $posCaja = PosCaja::where('user_id', $user_id)
                ->where('estado', '1')
                ->latest()
                ->first();

        if ($posCaja) {
            return response()->json($posCaja);
        } else {
            return response()->json(null);
        }
    }

    public function store(Request $request)
    {
        $posCaja = new PosCaja();
        $posCaja->user_id = $request->user_id;
    $posCaja->par_empresa_id = $request->empresa_id;
    $posCaja->par_sucursal_id = $request->sucursal_id;
        $posCaja->fecha = now();
        $posCaja->save();

        $movimiento = new PosCajaMovimiento();
        $movimiento->caja_id = $posCaja->id;
        $movimiento->motivo = $request->motivo;
        $movimiento->monto = $request->monto ?? 0;
        $movimiento->metodo_id = $request->metodo_id;
        $movimiento->caja_t_movimiento_id = $request->caja_t_movimiento_id;
    $movimiento->par_empresa_id = $request->empresa_id;
    $movimiento->par_sucursal_id = $request->sucursal_id;
        $movimiento->fecha = now();
        $movimiento->save();

        return response()->json([
            'success' => true,
            'caja' => $posCaja,
            'movimiento' => $movimiento
        ]);
    }

    public function show(PosCaja $posCaja)
    {
        return $posCaja;
    }

    public function update(Request $request, PosCaja $posCaja)
    {
        //
    }

    public function destroy(PosCaja $posCaja)
    {
        //
    }
}
