<?php


namespace App\Http\Controllers\Pos;
use Illuminate\Routing\Controller;

use App\Models\Pos\PosCategoria;
use Illuminate\Http\Request;

class PosCategoriaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return PosCategoria::where('estado',1)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $posCategoria = new PosCategoria();
        $posCategoria->nombre = $request->nombre;
        $posCategoria->save();
        return $posCategoria;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PosCategoria  $posCategoria
     * @return \Illuminate\Http\Response
     */
    public function show(PosCategoria $posCategoria)
    {
        return $posCategoria;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PosCategoria  $posCategoria
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PosCategoria $posCategoria)
    {
        $posCategoria->nombre = $request->nombre;
        $posCategoria->save();
        return $posCategoria;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PosCategoria  $posCategoria
     * @return \Illuminate\Http\Response
     */
    public function destroy(PosCategoria $posCategoria)
    {
        $posCategoria->estado = 0;
        $posCategoria->save();
    }
}
