<?php
namespace App\Http\Controllers\Pos;
use Illuminate\Routing\Controller;

use App\Models\Pos\PosCliente;
use Illuminate\Http\Request;

class PosClienteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return PosCliente::with(['parPais', 'parRegion', 'parComuna', 'parCiudad'])->where('estado', 1)->orderBy('nombre', 'asc')->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    public function store(Request $request)
    {
        $posCliente = new PosCliente();
        $posCliente->nombre = $request->nombre;
        $posCliente->rut = $request->rut;
        $posCliente->razon_social = $request->razon_social;
        $posCliente->par_pais_id = $request->pais_id;
        $posCliente->par_region_id = $request->region_id;
        $posCliente->par_comuna_id = $request->comuna_id;
        $posCliente->par_ciudad_id = $request->ciudad_id;
        $posCliente->direccion = $request->direccion;
        $posCliente->par_empresa_id = $request->par_empresa_id;
        $posCliente->save();
        return $posCliente;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PosCliente  $posCliente
     * @return \Illuminate\Http\Response
     */
    public function show(PosCliente $posCliente)
    {
        $posCliente->pais = $posCliente->Pais;
        $posCliente->region = $posCliente->Region;
        $posCliente->comuna = $posCliente->Comuna;
        $posCliente->ciudad = $posCliente->Ciudad;
        $posCliente->empresa = $posCliente->empresa;
        $posCliente->sucursal = $posCliente->sucursal;
        $posCliente->user = $posCliente->user;
        return $posCliente;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PosCliente  $posCliente
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PosCliente $posCliente)
    {
        $posCliente->nombre = $request->nombre;
        $posCliente->rut = $request->rut;
        $posCliente->razon_social = $request->razon_social;
        $posCliente->par_pais_id = $request->pais_id;
        $posCliente->par_region_id = $request->region_id;
        $posCliente->par_comuna_id = $request->comuna_id;
        $posCliente->par_ciudad_id = $request->ciudad_id;
        $posCliente->direccion = $request->direccion;
        $posCliente->save();
        return $posCliente;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PosCliente  $posCliente
     * @return \Illuminate\Http\Response
     */
    public function destroy(PosCliente $posCliente)
    {
        $posCliente->estado = 0;
        $posCliente->save();
    }
}
