<?php

namespace App\Http\Controllers\Pos;

use Illuminate\Routing\Controller;
use Illuminate\Http\Request;
use App\Models\Pos\PosFolio;

class PosFolioController extends Controller
{
    // Implementación ligera: métodos CRUD básicos

    public function index()
    {
        return PosFolio::where('estado', 1)->get();
    }

    public function store(Request $request)
    {
        return PosFolio::create($request->all());
    }

    public function show(PosFolio $posFolio)
    {
        return $posFolio;
    }

    public function update(Request $request, PosFolio $posFolio)
    {
        $posFolio->update($request->all());
        return $posFolio;
    }

    public function destroy(PosFolio $posFolio)
    {
        $posFolio->estado = 0;
        $posFolio->save();
        return response()->json(['ok' => true]);
    }
}
