<?php

namespace App\Http\Controllers\Pos;

use App\Models\Contabilidad\ConImpuestoTasa;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class PosImpuestoTasaController extends Controller
{
    public function index()
    {
        //
    }

    public function tasa(Request $request)
    {
        $fecha = $request->input('fecha');
        if (empty($fecha)) {
            return response()->json(['error' => 'fecha es requerida (YYYY-MM-DD)'], 422);
        }

        $query = DB::table('pos_impuesto_tasas')->where('activo', 1)
            ->whereDate('vigente_desde', '<=', $fecha)
            ->where(function ($q) use ($fecha) {
                $q->whereNull('vigente_hasta')->orWhereDate('vigente_hasta', '>=', $fecha);
            });

        if ($request->filled('pos_impuesto_id')) {
            $query->where('pos_impuesto_id', (int) $request->input('pos_impuesto_id'));
        }

        $rows = $query->select(['id','pos_impuesto_id','tasa','monto_fijo','vigente_desde','vigente_hasta','activo','created_at','updated_at'])->get();

        return response()->json(['ok' => true, 'data' => $rows]);
    }

    public function store(Request $request)
    {
        //
    }

    public function show(ConImpuestoTasa $conImpuestoTasa)
    {
        //
    }

    public function update(Request $request, ConImpuestoTasa $conImpuestoTasa)
    {
        //
    }

    public function destroy(ConImpuestoTasa $conImpuestoTasa)
    {
        //
    }
}
