<?php

namespace App\Http\Controllers\Pos;

use App\Models\User;
use App\Models\Pos\PosBodega; 
use App\Models\Pos\PosArticulo; 
use Illuminate\Http\Request;
use App\Models\Pos\PosInventario;
use App\Models\Pos\PosBodegaArticulo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Controller;

class PosInventarioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        return PosArticulo::with(['PosBodega','Categoria','Medida','Marca'])->where('estado',1)->orderBy('nombre')->get();

    }

    public function inventario()
    {
        
        {

            $model= PosArticulo::where('estado',1)->orderBy('nombre')->get();
            $list = [];
            foreach($model as $m){
                $list[] = $this->kardex($m);
            }
            return $list;
        }
       
    }
    public function categoria()
    {
        
        {

            $model= PosArticulo::where('estado',1)->orderBy('nombre')->get();
            $list = [];
            foreach($model as $m){
                $list[] = $this->Kardex3($m);
            }
            return $list;
        }
       
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

  public function Kardex(Request $request)
{
    $articulo = $request->articulo;
    if (!$articulo) {
        return response()->json(['error' => 'El filtro de artículo es obligatorio'], 400);
    }

    $movimientos = PosInventario::where('pos_bodega_articulo_id', $articulo)
        ->where('estado', 1)
        ->orderBy('fecha', 'asc')
        ->orderBy('id', 'asc')
        ->get();

    if ($movimientos->isEmpty()) {
        return response()->json(['error' => 'No se encontraron movimientos para este artículo'], 404);
    }

    $bodegaArticulo = PosBodegaArticulo::join('pos_articulos', 'pos_bodega_articulos.pos_articulo_id', '=', 'pos_articulos.id')
        ->leftJoin('pos_bodegas', 'pos_bodega_articulos.pos_bodega_id', '=', 'pos_bodegas.id')
        ->where('pos_bodega_articulos.id', $articulo)
        ->select(
            'pos_bodega_articulos.*',
            'pos_articulos.nombre as articulo_nombre',
            'pos_articulos.barra as articulo_barra',
            'pos_bodegas.nombre as bodega_nombre'
        )
        ->first();

    if (!$bodegaArticulo) {
        return response()->json(['error' => 'Artículo no encontrado'], 404);
    }

    $saldoAcumulado = 0.0;
    $kardex = [];

    foreach ($movimientos as $movimiento) {
        $tipoMov   = (int)$movimiento->movimiento;
        $cStock    = (int)($movimiento->c_stock ?? 1); // 1=físico, 0=lógico (reserva)
        $cantidad  = (float)$movimiento->cantidad;

        $margenUtilidad   = 0.0;
        $utilidadUnitaria = 0.0;
        $utilidadTotal    = 0.0;
        $ventaUnitaria    = 0.0;

        switch ($tipoMov) {
            case 1: // Entrada (compra)
                $saldoAcumulado += $cantidad;
                break;

            case 2: // Venta
                // Solo descuenta el saldo si afecta stock físico
                if ($cStock === 1) {
                    $saldoAcumulado -= $cantidad;
                }
                // Para utilidades, solo consideraremos c_stock=1 más abajo
                $precioCompra = (float)($movimiento->compra ?? 0);
                $precioVenta  = (float)($movimiento->venta  ?? 0);
                $ventaUnitaria = ($cStock === 1) ? $precioVenta : 0.0; // mostrar venta solo en salida física

                if ($cStock === 1 && $precioVenta > 0) {
                    $utilidadUnitaria = $precioVenta - $precioCompra;
                    $margenUtilidad   = ($utilidadUnitaria / $precioVenta) * 100;
                    $utilidadTotal    = $utilidadUnitaria * $cantidad;
                }
                break;

            case 3: // Traspaso salida (origen)
                $saldoAcumulado -= $cantidad;
                break;

            case 4: // Traspaso en Origen (en tránsito al destino): no afecta saldo disponible
                // $saldoAcumulado += 0;
                break;

            case 5: // Tránsito intermedio: tampoco afecta saldo disponible
                // $saldoAcumulado += 0;
                break;

            case 6: // Traspaso Recepcionado (destino) => ENTRA stock físico
                $saldoAcumulado += $cantidad;
                break;

            default:
                // otros movimientos no afectan el saldo
                break;
        }

        $kardex[] = [
            'id'                     => $movimiento->id,
            'movimiento'             => $tipoMov,
            'fecha'                  => $movimiento->fecha,
            'pos_bodega_articulo_id' => $movimiento->pos_bodega_articulo_id,
            'texto'                  => $movimiento->texto,
            'pos_bodega_id'          => $movimiento->pos_bodega_id,
            'c_stock'                => $cStock,
            'cantidad'               => $cantidad,
            'compra'                 => $movimiento->compra,
            'venta'                  => $ventaUnitaria, // solo mostramos venta en la salida física
            'neto'                   => $movimiento->neto,
            'impuesto'               => $movimiento->impuesto,
            'total'                  => $movimiento->total,
            'tipo'                   => $movimiento->tipo,
            'estado'                 => $movimiento->estado,
            'saldo_acumulado'        => $saldoAcumulado,
            'tipo_movimiento'        => match ($tipoMov) {
                1 => 'Entrada',
                2 => ($cStock === 1 ? 'Venta (física)' : 'Venta (reserva)'),
                3 => 'Traspaso salida',
                4 => 'Traspaso en Origen',
                5 => 'Traspaso en Tránsito',
                6 => 'Traspaso Recepcionado',
                default => 'Otro',
            },
            'margen_utilidad'        => round($margenUtilidad, 2),
            'utilidad_unitaria'      => $utilidadUnitaria,
            'utilidad_total'         => $utilidadTotal,
        ];
    }

    // Solo considerar ventas físicas (mov=2 y c_stock=1) para utilidades
    $ventas = array_filter($kardex, fn($it) => $it['movimiento'] === 2 && $it['c_stock'] === 1 && $it['venta'] > 0);
    $ventasCount = count($ventas);

    $totalUtilidad = array_sum(array_map(fn($it) => (($it['venta'] - $it['compra']) * $it['cantidad']), $ventas));
    $totalCostoVentas = array_sum(array_map(fn($it) => ($it['compra'] * $it['cantidad']), $ventas));
    $totalVentas = array_sum(array_map(fn($it) => ($it['venta'] * $it['cantidad']), $ventas));
    $promedioMargen = $ventasCount > 0
        ? array_sum(array_map(fn($it) => $it['margen_utilidad'], $ventas)) / $ventasCount
        : 0.0;

    $resultado = [
        'articulo' => [
            'id'     => $bodegaArticulo->id,
            'nombre' => $bodegaArticulo->articulo_nombre,
            'barra'  => $bodegaArticulo->articulo_barra,
            'venta'  => $bodegaArticulo->p_venta,
            'bodega' => $bodegaArticulo->bodega_nombre,
            'en_origen'     => $bodegaArticulo->en_origen_in,
            'en_transito'   => $bodegaArticulo->en_transito_in,
            'comprometido'  => $bodegaArticulo->comprometido,
            'costo_promedio'=> ($bodegaArticulo->stock && $bodegaArticulo->stock > 0)
                ? round(($bodegaArticulo->costo ?? 0) / $bodegaArticulo->stock, 4)
                : 0.0,
        ],
        'kardex'             => $kardex,
        'saldo_final'        => $saldoAcumulado,
        'total_movimientos'  => count($kardex),
        'total_ventas'       => $ventasCount,
        'resumen_utilidades' => [
            'total_utilidad'  => $totalUtilidad,
            'promedio_margen' => round($promedioMargen, 2),
            'catidad_ventas'  => $ventasCount,
            'total_ventas'    => $totalVentas,
            'costo_ventas'    => $totalCostoVentas,
        ],
    ];

    return response()->json($resultado);
}



     
    public function store(Request $request)
    {
        $posinventario = new PosInventario();
        $posinventario->pos_articulo_id = $request->pos_articulo_id;
        $posinventario->pos_bodega_id = $request->pos_bodega_id;
        $posinventario->fecha = $request->fecha;
        $posinventario->tipo = $request->tipo;
        $posinventario->compra = $request->compra;
        $posinventario->venta = $request->venta;
        $posinventario->total = $request->compra + $request->venta;
        $posinventario->impuesto = 0;
        $posinventario->v_impuesto = 0;
        $posinventario->cantidad = $request->cantidad;
        $posinventario->motivo = $request->motivo;
        $posinventario->save();
        return $posinventario;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PosInventario  $posinventario
     * @return \Illuminate\Http\Response
     */
    public function show(PosInventario $posinventario)
    {
        // attach the user who created/updated this record if relation exists
        $posinventario->user = $posinventario->User ?? null;
        return $posinventario;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PosInventario  $posInventario
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PosInventario $posInventario)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PosInventario  $posInventario
     * @return \Illuminate\Http\Response
     */
    public function destroy(PosInventario $posInventario)
    {
        $posInventario->estado=0;
        $posInventario->save();
    }
}
